/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_toArrayTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenEmpty() {
        TransactionalArrayList list = new TransactionalArrayList();
        Object[] result = list.toArray();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.length);
    }

    @Test
    public void whenNonEmpty() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        Object[] result = list.toArray();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((Object)"a", (Object)result[0]);
        Assert.assertEquals((Object)"b", (Object)result[1]);
        Assert.assertEquals((Object)"c", (Object)result[2]);
    }
}

