/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_TakeLastPutFirstStressTest {
    private int takeFirstThreadCount = 2;
    private int putLastThreadCount = 2;
    private int dequeCapacity;
    private int produceCount = 200000;
    private AtomicLong itemGenerator;
    private AtomicLong takeCounter;
    private TransactionalLinkedList<Long> list;
    private PutFirstThread[] putLastThreads;
    private TakeLastThread[] takeFirstThreads;

    @Before
    public void setUp() {
        int k;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.itemGenerator = new AtomicLong();
        this.takeCounter = new AtomicLong(this.putLastThreadCount * this.produceCount);
        this.list = new TransactionalLinkedList(this.dequeCapacity);
        this.putLastThreads = new PutFirstThread[this.putLastThreadCount];
        for (k = 0; k < this.putLastThreadCount; ++k) {
            this.putLastThreads[k] = new PutFirstThread(k);
        }
        this.takeFirstThreads = new TakeLastThread[this.takeFirstThreadCount];
        for (k = 0; k < this.takeFirstThreadCount; ++k) {
            this.takeFirstThreads[k] = new TakeLastThread(k);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void runWithCapacity() {
        this.dequeCapacity = 10;
        this.list = new TransactionalLinkedList(this.dequeCapacity);
        TestUtils.startAll((TestThread[])this.putLastThreads);
        TestUtils.startAll((TestThread[])this.takeFirstThreads);
        TestUtils.joinAll((TestThread[])this.putLastThreads);
        TestUtils.joinAll((TestThread[])this.takeFirstThreads);
    }

    @Test
    public void runWithoutCapacity() {
        this.dequeCapacity = Integer.MAX_VALUE;
        this.list = new TransactionalLinkedList(this.dequeCapacity);
        TestUtils.startAll((TestThread[])this.putLastThreads);
        TestUtils.startAll((TestThread[])this.takeFirstThreads);
        TestUtils.joinAll((TestThread[])this.putLastThreads);
        TestUtils.joinAll((TestThread[])this.takeFirstThreads);
    }

    public class PutFirstThread
    extends TestThread {
        public PutFirstThread(int id) {
            super("PutFirstThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < TransactionalLinkedList_TakeLastPutFirstStressTest.this.produceCount; ++k) {
                TransactionalLinkedList_TakeLastPutFirstStressTest.this.list.putFirst((Object)TransactionalLinkedList_TakeLastPutFirstStressTest.this.itemGenerator.incrementAndGet());
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }
    }

    public class TakeLastThread
    extends TestThread {
        public TakeLastThread(int id) {
            super("TakeLastThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while (TransactionalLinkedList_TakeLastPutFirstStressTest.this.takeCounter.decrementAndGet() > 0L) {
                Long l = (Long)TransactionalLinkedList_TakeLastPutFirstStressTest.this.list.takeLast();
                if (l == null) {
                    throw new NullPointerException();
                }
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

