/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_equalsTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void whenComparedWithDifferentListImplementation() {
        TransactionalLinkedList list1 = new TransactionalLinkedList();
        list1.add((Object)"1");
        list1.add((Object)"2");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("1");
        list2.add("2");
        Assert.assertEquals((Object)list1, list2);
        Assert.assertEquals(list2, (Object)list1);
    }

    @Test
    public void whenEquals() {
        TransactionalLinkedList list1 = new TransactionalLinkedList();
        list1.add((Object)"1");
        list1.add((Object)"2");
        TransactionalLinkedList list2 = new TransactionalLinkedList();
        list2.add((Object)"1");
        list2.add((Object)"2");
        Assert.assertEquals((Object)list1, (Object)list2);
        Assert.assertEquals((Object)list2, (Object)list1);
    }

    @Test
    public void whenSizeNonEqual_thenNotEqual() {
        TransactionalLinkedList list1 = new TransactionalLinkedList();
        list1.add((Object)"1");
        list1.add((Object)"2");
        TransactionalLinkedList list2 = new TransactionalLinkedList();
        list2.add((Object)"1");
        list2.add((Object)"2");
        list2.add((Object)"3");
        Assert.assertFalse((boolean)list1.equals((Object)list2));
        Assert.assertFalse((boolean)list2.equals((Object)list1));
    }

    @Test
    public void whenSizeEqualButContentDifferent_thenNotEqual() {
        TransactionalLinkedList list1 = new TransactionalLinkedList();
        list1.add((Object)"1");
        list1.add((Object)"2");
        TransactionalLinkedList list2 = new TransactionalLinkedList();
        list2.add((Object)"2");
        list2.add((Object)"1");
        Assert.assertFalse((boolean)list1.equals((Object)list2));
        Assert.assertFalse((boolean)list2.equals((Object)list1));
    }

    @Test
    public void listNeverEqualsNull() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        Assert.assertFalse((boolean)list.equals(null));
        list.add((Object)"1");
        list.add((Object)"2");
        Assert.assertFalse((boolean)list.equals(null));
    }

    @Test
    public void testEqualsThis() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        Assert.assertTrue((boolean)list.equals((Object)list));
        list.add((Object)"foo");
        list.add((Object)"bar");
        Assert.assertTrue((boolean)list.equals((Object)list));
    }
}

