/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_offerFirstTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void offerFirstNullFails() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.offerFirst(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void offerFirstOnEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        boolean result = list.offerFirst((Object)"1");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void offerFirstOnNonEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        boolean result = list.offerFirst((Object)"3");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[3, 1, 2]", (Object)list.toString());
    }

    @Test
    public void offerFirstOnFullDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList(1);
        list.add((Object)"1");
        long version = this.stm.getVersion();
        boolean result = list.offerFirst((Object)"2");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void offerOnUnboundList() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        int txCount = 1000000;
        for (int k = 0; k < txCount; ++k) {
            if (list.offerFirst((Object)k)) continue;
            Assert.fail();
        }
        Assert.assertEquals((long)(version + (long)txCount), (long)this.stm.getVersion());
    }
}

