/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_offerLastTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void offerLastNullFails() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.offerLast(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void offerLastOnEmptyQueue() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        boolean result = list.offerLast((Object)"1");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void offerLastOnNonEmptyQueue() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.offerLast((Object)"1");
        long version = this.stm.getVersion();
        boolean result = list.offerLast((Object)"2");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2]", (Object)list.toString());
    }

    @Test
    public void offerLastOnFullQueue() {
        TransactionalLinkedList list = new TransactionalLinkedList(1);
        list.offerLast((Object)"1");
        long version = this.stm.getVersion();
        boolean result = list.offerLast((Object)"2");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void offerOnUnboundList() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        int txCount = 1000000;
        for (int k = 0; k < txCount; ++k) {
            if (list.offerLast((Object)k)) continue;
            Assert.fail();
        }
        Assert.assertEquals((long)(version + (long)txCount), (long)this.stm.getVersion());
    }
}

