/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;

public class ExecutorPerformanceStressTest {
    private int taskCount = 1000000;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testThreadPoolExecutor() throws InterruptedException {
        this.test(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    @Test
    public void testTransactionalThreadPoolExecutor() throws InterruptedException {
        this.test((ExecutorService)new TransactionalThreadPoolExecutor());
    }

    public void test(ExecutorService executor) throws InterruptedException {
        long startNs = System.nanoTime();
        for (int k = 0; k < this.taskCount; ++k) {
            executor.execute(new Task());
        }
        executor.shutdown();
        if (executor instanceof TransactionalThreadPoolExecutor) {
            ((TransactionalThreadPoolExecutor)executor).awaitTermination();
        } else {
            executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        long elapsedNs = System.nanoTime() - startNs;
        System.out.printf("Execution of %s tasks took %s ms\n", this.taskCount, TimeUnit.NANOSECONDS.toMillis(elapsedNs));
    }

    public class Task
    implements Runnable {
        @Override
        public void run() {
        }
    }
}

