/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_awaitTerminationLongTest {
    private TransactionalThreadPoolExecutor executor;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void whenUnstarted() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                TransactionalThreadPoolExecutor_awaitTerminationLongTest.this.executor.awaitTermination();
            }
        };
        thread.start();
        TestUtils.sleepMs((long)1000L);
        this.executor.shutdownNow();
        thread.join();
        thread.assertNothingThrown();
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    public void whenStarted() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                TransactionalThreadPoolExecutor_awaitTerminationLongTest.this.executor.awaitTermination();
            }
        };
        thread.start();
        TestUtils.sleepMs((long)1000L);
        this.executor.shutdownNow();
        thread.join();
        thread.assertNothingThrown();
        Assert.assertTrue((this.executor.isShutdown() || this.executor.isTerminated() ? 1 : 0) != 0);
    }

    @Test
    public void whenShutdown() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)50000L);
            }
        };
        this.executor.execute(task);
        TestUtils.sleepMs((long)1000L);
        this.executor.shutdown();
        TestThread thread = new TestThread(){

            public void doRun() throws Exception {
                TransactionalThreadPoolExecutor_awaitTerminationLongTest.this.executor.awaitTermination();
            }
        };
        thread.start();
        TestUtils.sleepMs((long)1000L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        this.executor.shutdownNow();
        thread.join();
        thread.assertNothingThrown();
    }

    @Test
    public void whenTerminated() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.shutdown();
        boolean result = this.executor.awaitTermination(1L, TimeUnit.HOURS);
        Assert.assertTrue((boolean)result);
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }
}

