/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_awaitTerminationUninterruptiblyTest {
    private TransactionalThreadPoolExecutor executor;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void whenUnstarted() {
        this.executor = new TransactionalThreadPoolExecutor();
        AwaitThread awaitThread = new AwaitThread();
        awaitThread.start();
        TestUtils.sleepSome();
        TestUtils.assertAlive((Thread[])new Thread[]{awaitThread});
        this.executor.shutdown();
        TestUtils.sleepSome();
        TestUtils.assertNotAlive((Thread[])new Thread[]{awaitThread});
    }

    @Test
    public void whenStarted() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                TransactionalThreadPoolExecutor_awaitTerminationUninterruptiblyTest.this.executor.awaitTermination();
            }
        };
        t.start();
        TestUtils.sleepSome();
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.executor.shutdownNow();
        t.join();
        TestUtils.sleepSome();
        t.assertNothingThrown();
    }

    @Test
    public void whenShutdown() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)1000000L);
            }
        });
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                TransactionalThreadPoolExecutor_awaitTerminationUninterruptiblyTest.this.executor.awaitTermination();
            }
        };
        t.start();
        TestUtils.sleepSome();
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.executor.shutdownNow();
        t.join();
        t.assertNothingThrown();
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }

    @Test
    public void whenTerminated() throws InterruptedException {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.shutdown();
        this.executor.awaitTerminationUninterruptibly();
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }

    private class AwaitThread
    extends TestThread {
        private AwaitThread() {
            super("AwaitThread");
        }

        public void doRun() throws Exception {
            TransactionalThreadPoolExecutor_awaitTerminationUninterruptiblyTest.this.executor.awaitTerminationUninterruptibly();
        }
    }
}

