/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class IntRefPerformanceStressTest {
    private int count = 50;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        IntRef ref = new IntRef();
        long startNs = System.nanoTime();
        for (int k = 0; k < this.count; ++k) {
            ref.inc();
            if (k % 5000000 != 0) continue;
            System.out.printf("at %s\n", k);
        }
        Assert.assertEquals((long)this.count, (long)ref.get());
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (double)this.count * 1.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)periodNs;
        System.out.printf("%s Transaction/second\n", TestUtils.format((double)transactionPerSecond));
    }
}

