/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.IntRef;

public class IntRefTest {
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        IntRef ref = new IntRef(1);
        long version = this.stm.getVersion();
        ref.inc();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)ref.get());
    }

    @Test
    public void constructorWithNoArg() {
        IntRef ref = new IntRef();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        IntRef ref = new IntRef(10);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        IntRef ref = new IntRef(10);
        long old = ref.set(100);
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        IntRef ref = new IntRef(100);
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc(10));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc(-11));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        IntRef ref = new IntRef(100);
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec(10));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec(-11));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        IntRef ref1 = new IntRef(10);
        IntRef ref2 = new IntRef(10);
        IntRef ref3 = new IntRef(20);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        IntRef ref = new IntRef(10);
        Assert.assertEquals((long)10L, (long)ref.hashCode());
        ref.set(200);
        Assert.assertEquals((long)200L, (long)ref.hashCode());
    }

    @Test
    public void testAtomic() {
        IntRef ref1 = new IntRef(10);
        IntRef ref2 = new IntRef(20);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref1.get());
        Assert.assertEquals((long)20L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(IntRef ... refs) {
        for (IntRef ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }

    @Test
    public void await() {
        IntRef txInt = new IntRef();
        SetThread t = new SetThread(txInt, 3);
        t.start();
        txInt.await(3);
    }

    @Test
    public void awaitTest() {
        final IntRef ref = new IntRef();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                ref.await(2);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set(1);
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set(2);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    public class SetThread
    extends TestThread {
        private final IntRef txInt;
        private final int value;

        public SetThread(IntRef txInt, int value) {
            super("SetThread");
            this.txInt = txInt;
            this.value = value;
        }

        public void doRun() throws Exception {
            TestUtils.sleepMs((long)300L);
            this.txInt.set(this.value);
        }
    }
}

