/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.LongRef;

public class LongRefPerformanceTest {
    private int threadCount;
    private long incCountPerThread = 100000000L;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_1() {
        this.test(1);
    }

    @Test
    public void test_2() {
        this.test(2);
    }

    @Test
    public void test_4() {
        this.test(4);
    }

    @Test
    public void test_8() {
        this.test(8);
    }

    @Test
    public void test_16() {
        this.test(16);
    }

    public void test(int threadCount) {
        this.threadCount = threadCount;
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = (long)threadCount * this.incCountPerThread;
        Assert.assertEquals((long)totalIncCount, (long)this.sum((AtomicIncThread[])threads));
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    private long sum(AtomicIncThread[] threads) {
        long result = 0L;
        for (AtomicIncThread thread : threads) {
            result += thread.ref.get();
        }
        return result;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        private final LongRef ref;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
            this.ref = new LongRef();
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < LongRefPerformanceTest.this.incCountPerThread) {
                this.ref.inc(1L);
                if (k % 10000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

