/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldgranularity;

import java.util.LinkedList;
import java.util.Map;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.asm.CloneMap;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class FieldGranularityTransformer
implements Opcodes {
    private final ClassNode classNode;
    private final ClassMetadata classMetadata;
    private final MetadataRepository metadataRepository;
    private final ClassLoader classLoader;

    public FieldGranularityTransformer(ClassLoader classLoader, ClassNode classNode, MetadataRepository metadataRepository) {
        if (classNode == null) {
            throw new RuntimeException();
        }
        this.metadataRepository = metadataRepository;
        this.classLoader = classLoader;
        this.classNode = classNode;
        this.classMetadata = metadataRepository.loadClassMetadata(classLoader, classNode.name);
    }

    public ClassNode transform() {
        this.fixFields();
        this.fixFieldAccessInMethods();
        this.addInitializationLogicToConstructors();
        return this.classNode;
    }

    private void fixFields() {
        LinkedList<FieldNode> fields = new LinkedList<FieldNode>();
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (fieldMetadata.hasFieldGranularity()) {
                String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldNode.desc);
                FieldNode fixedFieldNode = new FieldNode(4113, fieldNode.name, referenceDesc, null, null);
                fields.add(fixedFieldNode);
                continue;
            }
            fields.add(fieldNode);
        }
        this.classNode.fields = fields;
    }

    private void fixFieldAccessInMethods() {
        LinkedList<MethodNode> methods = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.classNode.methods) {
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (methodMetadata.isTransactional()) {
                methodNode = this.fixMethod(methodNode);
            }
            methods.add(methodNode);
        }
        this.classNode.methods = methods;
    }

    private MethodNode fixMethod(MethodNode originalMethod) {
        CloneMap cloneMap = new CloneMap();
        MethodNode result = AsmUtils.cloneMethodWithoutInstructions((MethodNode)originalMethod, (CloneMap)cloneMap);
        result.instructions = this.fixInstructions(originalMethod, cloneMap);
        return result;
    }

    private InsnList fixInstructions(MethodNode originalMethod, CloneMap cloneMap) {
        InsnList instructions = new InsnList();
        block4: for (int k = 0; k < originalMethod.instructions.size(); ++k) {
            AbstractInsnNode originalInsn = originalMethod.instructions.get(k);
            switch (originalInsn.getOpcode()) {
                case 181: {
                    FieldInsnNode fieldInsn = (FieldInsnNode)originalInsn;
                    ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, fieldInsn.owner);
                    FieldMetadata fieldMetadata = ownerMetadata.getFieldMetadata(fieldInsn.name);
                    Type originalFieldType = Type.getType((String)fieldMetadata.getDesc());
                    if (fieldMetadata.hasFieldGranularity()) {
                        boolean fieldIsCategory2 = AsmUtils.isCategory2((String)fieldMetadata.getDesc());
                        if (fieldIsCategory2) {
                            instructions.add((AbstractInsnNode)new InsnNode(93));
                            instructions.add((AbstractInsnNode)new InsnNode(88));
                        } else {
                            instructions.add((AbstractInsnNode)new InsnNode(95));
                        }
                        String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldMetadata.getDesc());
                        String referenceName = Type.getType((String)referenceDesc).getInternalName();
                        instructions.add((AbstractInsnNode)new FieldInsnNode(180, fieldInsn.owner, fieldInsn.name, referenceDesc));
                        if (fieldIsCategory2) {
                            instructions.add((AbstractInsnNode)new InsnNode(91));
                            instructions.add((AbstractInsnNode)new InsnNode(87));
                        } else {
                            instructions.add((AbstractInsnNode)new InsnNode(95));
                        }
                        if (originalFieldType.getSort() == 9 || originalFieldType.getSort() == 10) {
                            String objectDesc = Type.getDescriptor(Object.class);
                            MethodInsnNode methodInsn = new MethodInsnNode(182, referenceName, "set", String.format("(%s)%s", objectDesc, objectDesc));
                            instructions.add((AbstractInsnNode)methodInsn);
                        } else {
                            MethodInsnNode methodInsn = new MethodInsnNode(182, referenceName, "set", String.format("(%s)%s", fieldMetadata.getDesc(), fieldMetadata.getDesc()));
                            instructions.add((AbstractInsnNode)methodInsn);
                        }
                        if (fieldIsCategory2) {
                            instructions.add((AbstractInsnNode)new InsnNode(88));
                            continue block4;
                        }
                        instructions.add((AbstractInsnNode)new InsnNode(87));
                        continue block4;
                    }
                    instructions.add(originalInsn.clone((Map)cloneMap));
                    continue block4;
                }
                case 180: {
                    FieldInsnNode fieldInsn = (FieldInsnNode)originalInsn;
                    FieldMetadata fieldMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, fieldInsn.owner).getFieldMetadata(fieldInsn.name);
                    if (!fieldMetadata.hasFieldGranularity()) {
                        instructions.add(originalInsn.clone((Map)cloneMap));
                        continue block4;
                    }
                    String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldMetadata.getDesc());
                    String referenceName = Type.getType((String)referenceDesc).getInternalName();
                    instructions.add((AbstractInsnNode)new FieldInsnNode(180, fieldInsn.owner, fieldInsn.name, referenceDesc));
                    Type originalFieldType = Type.getType((String)fieldMetadata.getDesc());
                    if (originalFieldType.getSort() == 9 || originalFieldType.getSort() == 10) {
                        instructions.add((AbstractInsnNode)new MethodInsnNode(182, referenceName, "get", String.format("()%s", Type.getDescriptor(Object.class))));
                        if (originalFieldType.equals((Object)Type.getType(Object.class))) continue block4;
                        instructions.add((AbstractInsnNode)new TypeInsnNode(192, originalFieldType.getInternalName()));
                        continue block4;
                    }
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, referenceName, "get", String.format("()%s", fieldMetadata.getDesc())));
                    continue block4;
                }
                default: {
                    instructions.add(originalInsn.clone((Map)cloneMap));
                }
            }
        }
        return instructions;
    }

    private void addInitializationLogicToConstructors() {
        if (!this.classMetadata.hasManagedFieldsWithFieldGranularity()) {
            return;
        }
        for (MethodNode methodNode : this.classNode.methods) {
            int firstAfterSuper;
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (!methodMetadata.isTransactional() || !methodMetadata.isConstructor() || (firstAfterSuper = AsmUtils.firstIndexAfterSuper((MethodNode)methodNode, (String)this.classNode.superName)) < 0) continue;
            InsnList extraInstructions = new InsnList();
            for (FieldNode fieldNode : this.classNode.fields) {
                FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
                if (fieldMetadata.hasFieldGranularity()) {
                    extraInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldMetadata.getDesc());
                    String referenceName = Type.getType((String)referenceDesc).getInternalName();
                    extraInstructions.add((AbstractInsnNode)new TypeInsnNode(187, referenceName));
                    extraInstructions.add((AbstractInsnNode)new InsnNode(89));
                    extraInstructions.add((AbstractInsnNode)new MethodInsnNode(183, referenceName, "<init>", "()V"));
                    extraInstructions.add((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, fieldNode.name, referenceDesc));
                }
                AbstractInsnNode first = methodNode.instructions.get(firstAfterSuper);
                methodNode.instructions.insert(first, extraInstructions);
            }
        }
    }

    private static String findReferenceDesc(String desc) {
        Type type = Type.getType((String)desc);
        switch (type.getSort()) {
            case 9: {
                return "Lorg/multiverse/transactional/refs/BasicRef;";
            }
            case 1: {
                return "Lorg/multiverse/transactional/refs/BooleanRef;";
            }
            case 3: {
                return "Lorg/multiverse/transactional/refs/ByteRef;";
            }
            case 2: {
                return "Lorg/multiverse/transactional/refs/CharRef;";
            }
            case 8: {
                return "Lorg/multiverse/transactional/refs/DoubleRef;";
            }
            case 6: {
                return "Lorg/multiverse/transactional/refs/FloatRef;";
            }
            case 5: {
                return "Lorg/multiverse/transactional/refs/IntRef;";
            }
            case 7: {
                return "Lorg/multiverse/transactional/refs/LongRef;";
            }
            case 4: {
                return "Lorg/multiverse/transactional/refs/ShortRef;";
            }
            case 10: {
                return "Lorg/multiverse/transactional/refs/BasicRef;";
            }
        }
        throw new IllegalStateException("Unhandeled sort: " + type.getSort());
    }
}

