/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.mixins;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.multiverse.MultiverseConstants;
import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.RegisterRetryListenerResult;
import org.multiverse.utils.Bugshaker;
import org.multiverse.utils.TodoException;

public abstract class BasicMixin
implements AlphaTransactionalObject,
MultiverseConstants {
    private static final AtomicReferenceFieldUpdater<BasicMixin, Transaction> ___LOCKOWNER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BasicMixin.class, Transaction.class, "___lockOwner");
    private static final AtomicReferenceFieldUpdater<BasicMixin, Listeners> ___LISTENERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BasicMixin.class, Listeners.class, "___listeners");
    private volatile Transaction ___lockOwner;
    private volatile AlphaTranlocal ___tranlocal;
    private volatile Listeners ___listeners;

    @Override
    public final AlphaTranlocal ___load() {
        return this.___tranlocal;
    }

    @Override
    public final AlphaTranlocal ___load(long readVersion) {
        AlphaTranlocal second;
        AlphaTranlocal first;
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if ((first = this.___tranlocal) == null) {
            return null;
        }
        long firstVersion = first.getWriteVersion();
        if (firstVersion == readVersion) {
            return first;
        }
        if (firstVersion > readVersion) {
            throw this.createOldVersionNotFoundReadConflict(readVersion, first);
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (this.___lockOwner != null) {
            throw this.createLockNotFreeReadConflict();
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (first == (second = this.___tranlocal)) {
            return first;
        }
        if (second.getWriteVersion() == readVersion) {
            return second;
        }
        throw this.createOldVersionNotFoundReadConflict(readVersion, second);
    }

    private LockNotFreeReadConflict createLockNotFreeReadConflict() {
        if (LockNotFreeReadConflict.reuse) {
            return LockNotFreeReadConflict.INSTANCE;
        }
        String msg = String.format("Failed to load already locked transactionalobject '%s'", AlphaStmUtils.toTxObjectString(this));
        return new LockNotFreeReadConflict(msg);
    }

    private OldVersionNotFoundReadConflict createOldVersionNotFoundReadConflict(long readVersion, AlphaTranlocal found) {
        if (OldVersionNotFoundReadConflict.reuse) {
            return OldVersionNotFoundReadConflict.INSTANCE;
        }
        String msg = String.format("Can't load version '%s' transactionalobject '%s', the oldest version found is '%s'", readVersion, AlphaStmUtils.toTxObjectString(this), found.getWriteVersion());
        return new OldVersionNotFoundReadConflict(msg);
    }

    @Override
    public AlphaTranlocal ___openForCommutingOperation() {
        throw new TodoException();
    }

    @Override
    public Listeners ___storeUpdate(AlphaTranlocal update, long writeVersion, boolean releaseLock) {
        update.prepareForCommit(writeVersion);
        this.___tranlocal = update;
        Listeners listeners = null;
        if (this.___listeners != null) {
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            listeners = ___LISTENERS_UPDATER.getAndSet(this, null);
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (releaseLock) {
            this.___lockOwner = null;
        }
        return listeners;
    }

    @Override
    public void ___storeInitial(AlphaTranlocal tranlocal, long writeVersion) {
        tranlocal.prepareForCommit(writeVersion);
        this.___tranlocal = tranlocal;
    }

    public final Transaction ___getLockOwner() {
        return this.___lockOwner;
    }

    public boolean ___tryLock(Transaction lockOwner) {
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (this.___lockOwner != null) {
            return false;
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        return ___LOCKOWNER_UPDATER.compareAndSet(this, null, lockOwner);
    }

    public void ___releaseLock(Transaction expectedLockOwner) {
        if (this.___lockOwner == expectedLockOwner) {
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            this.___lockOwner = null;
        }
    }

    public final Listeners ___getListeners() {
        return this.___listeners;
    }

    @Override
    public final RegisterRetryListenerResult ___registerRetryListener(Latch listener, long minimumWakeupVersion) {
        AlphaTranlocal second;
        Listeners newListeners;
        Listeners oldListeners;
        boolean registered;
        AlphaTranlocal first;
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if ((first = this.___tranlocal) == null) {
            return RegisterRetryListenerResult.noregistration;
        }
        if (first.getWriteVersion() >= minimumWakeupVersion) {
            listener.open();
            return RegisterRetryListenerResult.opened;
        }
        do {
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            oldListeners = this.___listeners;
            newListeners = new Listeners(listener, oldListeners);
            registered = this.___listeners != oldListeners ? false : ___LISTENERS_UPDATER.compareAndSet(this, oldListeners, newListeners);
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            if (registered || first == (second = this.___tranlocal)) continue;
            listener.open();
            return RegisterRetryListenerResult.opened;
        } while (!registered);
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (first != (second = this.___tranlocal)) {
            if (this.___listeners == newListeners) {
                ___LISTENERS_UPDATER.compareAndSet(this, newListeners, oldListeners);
            }
            listener.open();
            return RegisterRetryListenerResult.opened;
        }
        return RegisterRetryListenerResult.registered;
    }
}

