/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.io.File;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Listeners;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.mixins.BasicMixin;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public final class AlphaProgrammaticLongRef
extends BasicMixin
implements ProgrammaticLongRef {
    private final AlphaStm stm;

    public static AlphaProgrammaticLongRef createUncommitted(AlphaStm stm) {
        return new AlphaProgrammaticLongRef(stm, null);
    }

    public AlphaProgrammaticLongRef(long value) {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)this.___openUnconstructed();
            tranlocal.value = value;
            long writeVersion = this.stm.getVersion();
            this.___storeInitial(tranlocal, writeVersion);
        } else {
            AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)tx.openForConstruction(this);
            tranlocal.value = value;
        }
    }

    public AlphaProgrammaticLongRef(AlphaStm stm, long value) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)this.___openUnconstructed();
        tranlocal.value = value;
        long writeVersion = stm.getVersion();
        this.___storeInitial(tranlocal, writeVersion);
    }

    public AlphaProgrammaticLongRef(AlphaTransaction tx, long value) {
        if (tx == null) {
            throw new NullPointerException();
        }
        this.stm = (AlphaStm)tx.getTransactionFactory().getStm();
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)tx.openForConstruction(this);
        tranlocal.value = value;
    }

    private AlphaProgrammaticLongRef(AlphaStm stm, File file) {
        this.stm = stm;
    }

    public long get() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            return this.atomicGet();
        }
        return this.get(tx);
    }

    public long get(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)alphaTx.openForRead(this);
        return tranlocal.value;
    }

    public long atomicGet() {
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)this.___load();
        if (tranlocal == null) {
            return 0L;
        }
        return tranlocal.value;
    }

    public long set(long newValue) {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            return this.atomicSet(newValue);
        }
        return this.set(tx, newValue);
    }

    public long set(Transaction tx, long newValue) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)alphaTx.openForWrite(this);
        long oldValue = tranlocal.value;
        tranlocal.value = newValue;
        return oldValue;
    }

    public long atomicSet(long newValue) {
        AlphaProgrammaticLongRefTranlocal newTranlocal;
        AlphaProgrammaticLongRefTranlocal committed = (AlphaProgrammaticLongRefTranlocal)this.___load();
        if (committed == null) {
            throw UncommittedReadConflict.createUncommittedReadConflict();
        }
        if (committed.value == newValue) {
            return newValue;
        }
        AlphaProgrammaticLongRefTranlocal lockOwner = newTranlocal = new AlphaProgrammaticLongRefTranlocal(this, false);
        lockOwner.setAttempt(1);
        this.lock(lockOwner);
        committed = (AlphaProgrammaticLongRefTranlocal)this.___load();
        long writeVersion = this.stm.getClock().tick();
        newTranlocal.value = newValue;
        newTranlocal.prepareForCommit(writeVersion);
        Listeners listeners = this.___storeUpdate(newTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
        return committed.value;
    }

    public void inc(long amount) {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            this.atomicInc(amount);
            return;
        }
        this.inc(tx, amount);
    }

    public void inc(Transaction tx, long amount) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)alphaTx.openForWrite(this);
        tranlocal.value += amount;
    }

    public void commutingInc(long amount) {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            this.atomicInc(amount);
            return;
        }
        this.commutingInc(tx, amount);
    }

    public void commutingInc(Transaction tx, long amount) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (amount == 0L) {
            return;
        }
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        AlphaProgrammaticLongRefTranlocal tranlocal = (AlphaProgrammaticLongRefTranlocal)alphaTx.openForCommutingWrite(this);
        if (tranlocal.isCommuting()) {
            tranlocal.commutingIncrements += amount;
        } else {
            tranlocal.value += amount;
        }
    }

    public void atomicInc(long amount) {
        AlphaProgrammaticLongRefTranlocal updateTranlocal;
        if (amount == 0L) {
            return;
        }
        AlphaProgrammaticLongRefTranlocal lockOwner = updateTranlocal = new AlphaProgrammaticLongRefTranlocal(this, false);
        lockOwner.setAttempt(1);
        this.lock(lockOwner);
        AlphaProgrammaticLongRefTranlocal currentTranlocal = (AlphaProgrammaticLongRefTranlocal)this.___load();
        if (currentTranlocal == null) {
            this.___releaseLock(lockOwner);
            throw UncommittedReadConflict.createUncommittedReadConflict();
        }
        long writeVersion = this.stm.getClock().tick();
        updateTranlocal.value = currentTranlocal.value + amount;
        updateTranlocal.prepareForCommit(writeVersion);
        Listeners listeners = this.___storeUpdate(updateTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
    }

    private void lock(Transaction lockOwner) {
        for (int attempt = 1; attempt <= this.stm.getMaxRetries(); ++attempt) {
            lockOwner.setAttempt(attempt);
            if (attempt == this.stm.getMaxRetries()) {
                throw new TooManyRetriesException();
            }
            if (this.___tryLock(lockOwner)) {
                return;
            }
            this.stm.getBackoffPolicy().delayedUninterruptible(lockOwner);
        }
    }

    public boolean atomicCompareAndSet(long expected, long update) {
        AlphaProgrammaticLongRefTranlocal updateTranlocal;
        AlphaProgrammaticLongRefTranlocal readonly = (AlphaProgrammaticLongRefTranlocal)this.___load();
        if (readonly == null) {
            throw UncommittedReadConflict.createUncommittedReadConflict();
        }
        if (readonly.value != expected) {
            return false;
        }
        if (readonly.value == update) {
            return true;
        }
        AlphaProgrammaticLongRefTranlocal lockOwner = updateTranlocal = new AlphaProgrammaticLongRefTranlocal(this, false);
        lockOwner.setAttempt(1);
        if (!this.___tryLock(lockOwner)) {
            return false;
        }
        AlphaProgrammaticLongRefTranlocal current = (AlphaProgrammaticLongRefTranlocal)this.___load();
        if (current.value != expected) {
            this.___releaseLock(lockOwner);
            return false;
        }
        long writeVersion = this.stm.getClock().tick();
        updateTranlocal.value = update;
        updateTranlocal.prepareForCommit(writeVersion);
        Listeners listeners = this.___storeUpdate(updateTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
        return true;
    }

    public void changeMod() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            this.atomicChangeMod();
            return;
        }
    }

    public void changeMod(Transaction tx) {
    }

    public void atomicChangeMod() {
    }

    @Override
    public AlphaTranlocal ___openForCommutingOperation() {
        return new AlphaProgrammaticLongRefTranlocal(this, true);
    }

    @Override
    public AlphaTranlocal ___openUnconstructed() {
        return new AlphaProgrammaticLongRefTranlocal(this, false);
    }
}

