/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions;

import org.multiverse.api.TraceLevel;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionSnapshot;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AbstractAlphaTransactionConfiguration;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;

public abstract class AbstractAlphaTransaction<C extends AbstractAlphaTransactionConfiguration, S extends AbstractTransactionSnapshot>
extends AbstractTransaction<C, S>
implements AlphaTransaction {
    public AbstractAlphaTransaction(C config) {
        super(config);
    }

    protected final UncommittedReadConflict createUncommittedException(AlphaTransactionalObject transactionalObject) {
        String msg = String.format("Can't open for read transactional object '%s' in transaction '%s' because the readonly transactional object has not been committed before. The cause of this problem is very likely that a reference to this transactional object escaped the creating transaction before that transaction was committed.'", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
        return new UncommittedReadConflict(msg);
    }

    protected final AlphaTranlocal load(AlphaTransactionalObject transactionalObject) {
        int spin = 0;
        while (true) {
            try {
                return transactionalObject.___load(this.version);
            }
            catch (LockNotFreeReadConflict lockNotFreeReadConflict) {
                if (spin >= ((AbstractAlphaTransactionConfiguration)this.config).maxReadSpinCount) {
                    throw lockNotFreeReadConflict;
                }
                ++spin;
                continue;
            }
            break;
        }
    }

    @Override
    public final AlphaTranlocal openForRead(AlphaTransactionalObject transactionalObject) {
        if (___TRACING_ENABLED && ((AbstractAlphaTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.fine)) {
            System.out.println(((AbstractAlphaTransactionConfiguration)this.config).familyName + " openForRead " + AlphaStmUtils.toTxObjectString(transactionalObject));
        }
        switch (this.statusInt) {
            case 0: {
                if (transactionalObject == null) {
                    return null;
                }
                this.start();
                return this.doOpenForRead(transactionalObject);
            }
            case 1: {
                if (transactionalObject == null) {
                    return null;
                }
                return this.doOpenForRead(transactionalObject);
            }
            case 2: {
                String preparedMsg = String.format("Can't open for read transactional object '%s' because transaction '%s' is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case 3: {
                String committedMsg = String.format("Can't open for read transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case 4: {
                String abortedMsg = String.format("Can't open for read transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException("unhandled transactionStatus: " + this.getStatus());
    }

    protected abstract AlphaTranlocal doOpenForRead(AlphaTransactionalObject var1);

    @Override
    public final AlphaTranlocal openForWrite(AlphaTransactionalObject transactionalObject) {
        if (___TRACING_ENABLED && ((AbstractAlphaTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.fine)) {
            System.out.println(((AbstractAlphaTransactionConfiguration)this.config).familyName + " openForWrite " + AlphaStmUtils.toTxObjectString(transactionalObject));
        }
        switch (this.getStatus()) {
            case New: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for write a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                this.start();
            }
            case Active: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for write a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                return this.doOpenForWrite(transactionalObject);
            }
            case Prepared: {
                String preparedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case Committed: {
                String committedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException("unhandled transactionStatus: " + this.getStatus());
    }

    protected abstract AlphaTranlocal doOpenForWrite(AlphaTransactionalObject var1);

    @Override
    public final AlphaTranlocal openForConstruction(AlphaTransactionalObject transactionalObject) {
        if (___TRACING_ENABLED && ((AbstractAlphaTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.fine)) {
            System.out.println(((AbstractAlphaTransactionConfiguration)this.config).familyName + " openForConstruction " + AlphaStmUtils.toTxObjectString(transactionalObject));
        }
        switch (this.getStatus()) {
            case New: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for construction a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                this.start();
            }
            case Active: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for construction a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                return this.doOpenForConstruction(transactionalObject);
            }
            case Prepared: {
                String preparedMsg = String.format("Can't open for construction transactional object '%s' because transaction '%s' already is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case Committed: {
                String committedMsg = String.format("Can't open for construction transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortedMsg = String.format("Can't open for construction transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException("unhandled transactionStatus: " + this.getStatus());
    }

    protected abstract AlphaTranlocal doOpenForConstruction(AlphaTransactionalObject var1);

    @Override
    public final AlphaTranlocal openForCommutingWrite(AlphaTransactionalObject transactionalObject) {
        if (___TRACING_ENABLED && ((AbstractAlphaTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.fine)) {
            System.out.println(((AbstractAlphaTransactionConfiguration)this.config).familyName + " openForCommutingWrite " + AlphaStmUtils.toTxObjectString(transactionalObject));
        }
        switch (this.getStatus()) {
            case New: 
            case Active: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for write a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                return this.doOpenForCommutingWrite(transactionalObject);
            }
            case Prepared: {
                String preparedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case Committed: {
                String committedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortedMsg = String.format("Can't open for commuting write transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException("unhandled transactionStatus: " + this.getStatus());
    }

    protected abstract AlphaTranlocal doOpenForCommutingWrite(AlphaTransactionalObject var1);

    protected final boolean doRegisterRetryLatch(Latch latch, long wakeupVersion) {
        if (!((AbstractAlphaTransactionConfiguration)this.config).explicitRetryAllowed) {
            String msg = String.format("Transaction %s explicitly doesn't allow for a retry (needed for blocking operations)", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
            throw new NoRetryPossibleException(msg);
        }
        SpeculativeConfiguration speculativeConfig = ((AbstractAlphaTransactionConfiguration)this.config).speculativeConfiguration;
        if (!((AbstractAlphaTransactionConfiguration)this.config).readTrackingEnabled) {
            if (speculativeConfig.isSpeculativeNoReadTrackingEnabled()) {
                speculativeConfig.signalSpeculativeReadTrackingDisabledFailure();
                throw SpeculativeConfigurationFailure.create();
            }
            return false;
        }
        return this.dodoRegisterRetryLatch(latch, wakeupVersion);
    }

    protected abstract boolean dodoRegisterRetryLatch(Latch var1, long var2);
}

