/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.commitlock.CommitLock;
import org.multiverse.api.commitlock.CommitLockFilter;
import org.multiverse.api.commitlock.CommitLockPolicy;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.update.AbstractUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public final class MonoUpdateAlphaTransaction
extends AbstractUpdateAlphaTransaction {
    private AlphaTranlocal attached;

    public MonoUpdateAlphaTransaction(UpdateConfiguration config) {
        super(config);
    }

    @Override
    protected void doDoReset() {
        this.attached = null;
    }

    @Override
    protected boolean tryWriteLocks(CommitLockFilter commitLockFilter) {
        CommitLockPolicy lockPolicy = ((UpdateConfiguration)this.config).commitLockPolicy;
        return lockPolicy.tryAcquire((CommitLock)this.attached, commitLockFilter, (Transaction)this);
    }

    @Override
    protected void doReleaseWriteLocksForFailure() {
        this.doReleaseWriteSetLocksForFailure(this.attached);
    }

    @Override
    protected void doReleaseWriteLocksForSuccess(long writeVersion) {
        this.doReleaseWriteLockForSuccess(this.attached, writeVersion);
    }

    @Override
    protected boolean isDirty() {
        return this.isDirty(this.attached);
    }

    @Override
    protected boolean hasWriteConflict() {
        return this.hasWriteConflict(this.attached);
    }

    @Override
    protected boolean hasReadWriteConflict() {
        return this.hasWriteConflict(this.attached);
    }

    @Override
    protected Listeners[] makeChangesPermanent(long writeVersion) {
        Listeners[] listenersArray;
        Listeners listeners = this.makePermanent(this.attached, writeVersion);
        if (listeners == null) {
            listenersArray = null;
        } else {
            Listeners[] listenersArray2 = new Listeners[1];
            listenersArray = listenersArray2;
            listenersArray2[0] = listeners;
        }
        return listenersArray;
    }

    @Override
    protected void attach(AlphaTranlocal tranlocal) {
        if (this.attached != null) {
            if (this.attached.getTransactionalObject() != tranlocal.getTransactionalObject()) {
                ((UpdateConfiguration)this.config).speculativeConfiguration.signalSpeculativeSizeFailure(1);
                throw SpeculativeConfigurationFailure.create();
            }
            this.attached = tranlocal;
        }
        this.attached = tranlocal;
    }

    @Override
    protected AlphaTranlocal findAttached(AlphaTransactionalObject transactionalObject) {
        if (this.attached == null || this.attached.getTransactionalObject() != transactionalObject) {
            return null;
        }
        return this.attached;
    }

    @Override
    protected boolean dodoRegisterRetryLatch(Latch latch, long wakeupVersion) {
        if (this.attached == null) {
            return false;
        }
        AlphaTransactionalObject txObject = this.attached.getTransactionalObject();
        switch (txObject.___registerRetryListener(latch, wakeupVersion)) {
            case registered: 
            case opened: {
                return true;
            }
            case noregistration: {
                return false;
            }
        }
        throw new IllegalStateException();
    }
}

