/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.Random;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;

public class BankDriver {
    int nb_threads = 8;
    int duration = 100000;
    int warmup = 2000;
    int m_max = 10;
    int m_read_frequency = 80;
    int m_write_frequency = 20;
    int m_read_threads = 5;
    int m_write_threads = 5;
    int nb = 10000;
    Account[] m_accounts;
    int init = 100;

    public void before() {
        this.m_accounts = new Account[this.nb];
        for (int i = 0; i < this.m_accounts.length; ++i) {
            this.m_accounts[i] = new Account("" + i);
            this.m_accounts[i].deposit(this.init);
        }
        System.out.println("Number of accounts  = " + this.nb);
        System.out.println("Initial amount      = " + this.init);
        System.out.println("Maximal transfer    = " + this.m_max);
        System.out.println("Read-all frequency  = " + this.m_read_frequency + "%");
        System.out.println("Write-all frequency = " + this.m_write_frequency + "%");
        System.out.println("Read-all threads    = " + this.m_read_threads);
        System.out.println("Write-all threads   = " + this.m_write_threads);
        System.out.println("Disjoint            = " + Account.s_disjoint);
        System.out.println("Yield               = " + Account.s_yield);
        System.out.println();
    }

    public void test() {
        int i;
        int i2;
        int i3;
        BenchmarkThread[] bt = new BenchmarkThread[this.nb_threads];
        for (int i4 = 0; i4 < bt.length; ++i4) {
            bt[i4] = this.createThread(i4, bt.length);
        }
        Thread[] t = new Thread[bt.length];
        for (i3 = 0; i3 < t.length; ++i3) {
            t[i3] = new Thread(bt[i3]);
        }
        System.out.print("Starting threads...");
        for (i3 = 0; i3 < t.length; ++i3) {
            System.out.print(" " + i3);
            bt[i3].setPhase(1);
            t[i3].start();
        }
        System.out.println();
        long wstart = System.currentTimeMillis();
        try {
            Thread.sleep(this.warmup);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long wend = System.currentTimeMillis();
        System.out.print("End of warmup phase...");
        for (int i5 = 0; i5 < bt.length; ++i5) {
            System.out.print(" " + i5);
            bt[i5].setPhase(2);
        }
        System.out.println();
        long tstart = System.currentTimeMillis();
        try {
            Thread.sleep(this.duration);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long tend = System.currentTimeMillis();
        System.out.print("End of test phase...");
        for (i2 = 0; i2 < bt.length; ++i2) {
            System.out.print(" " + i2);
            bt[i2].setPhase(3);
        }
        System.out.println();
        System.out.println("Waiting for threads to finish...");
        for (i2 = 0; i2 < t.length; ++i2) {
            try {
                t[i2].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        System.out.println("All threads returned successfully");
        int steps = 0;
        for (i = 0; i < bt.length; ++i) {
            steps += bt[i].getSteps();
        }
        System.out.println("RESULTS:\n");
        System.out.println("  Warmup duration (ms) = " + (wend - wstart));
        System.out.println("  Test duration (ms)   = " + (tend - tstart));
        System.out.println("  Nb iterations        = " + steps);
        System.out.println("  Stats                = " + this.getStats(bt));
        for (i = 0; i < bt.length; ++i) {
            System.out.println("    " + i + " : " + bt[i].getSteps() + " (" + bt[i].getStats() + ")");
        }
    }

    public BenchmarkThread createThread(int i, int nb) {
        return new BenchmarkThread(i, nb, this.m_accounts, this.m_max, this.m_read_frequency, this.m_write_frequency, this.m_read_threads, this.m_write_threads);
    }

    public String getStats(BenchmarkThread[] threads) {
        int total = 0;
        StringBuffer sb = new StringBuffer();
        sb.append(" [");
        for (int i = 0; i < this.m_accounts.length; ++i) {
            total = (int)((float)total + this.m_accounts[i].getBalance());
            sb.append(" " + i + "=" + this.m_accounts[i].getBalance());
        }
        sb.append(" ]");
        int transfers = 0;
        int reads = 0;
        int writes = 0;
        for (int i = 0; i < threads.length; ++i) {
            transfers += threads[i].m_nb_transfers;
            reads += threads[i].m_nb_reads;
            writes += threads[i].m_nb_writes;
        }
        return "T=" + transfers + ", R=" + reads + ", W=" + writes + ", TOTAL=" + total + sb.toString();
    }

    public static interface DeuceBenchmark {
        public static final int WARMUP_PHASE = 1;
        public static final int TEST_PHASE = 2;
        public static final int SHUTDOWN_PHASE = 3;
    }

    public static class BenchmarkThread
    extends DeuceBenchmarkThread {
        private final int m_id;
        private final int m_nb;
        private final Account[] m_accounts;
        private final int m_max;
        private final int m_read_frequency;
        private final int m_write_frequency;
        private final int m_read_threads;
        private final int m_write_threads;
        int m_nb_transfers;
        int m_nb_reads;
        int m_nb_writes;
        private final Random m_random;

        BenchmarkThread(int id, int nb, Account[] accounts, int max, int read_frequency, int write_frequency, int read_threads, int write_threads) {
            this.m_id = id;
            this.m_nb = nb;
            this.m_accounts = accounts;
            this.m_max = max;
            this.m_read_frequency = read_frequency;
            this.m_write_frequency = write_frequency;
            this.m_read_threads = read_threads;
            this.m_write_threads = write_threads;
            this.m_nb_writes = 0;
            this.m_nb_reads = 0;
            this.m_nb_transfers = 0;
            this.m_random = new Random();
        }

        @Override
        protected void step(int phase) {
            if (this.m_id < this.m_read_threads) {
                Account.computeTotal(this.m_accounts);
                if (phase == 2) {
                    ++this.m_nb_reads;
                }
            } else if (this.m_id < this.m_read_threads + this.m_write_threads) {
                Account.addInterest(this.m_accounts, 0.0f);
                if (phase == 2) {
                    ++this.m_nb_writes;
                }
            } else {
                int i = this.m_random.nextInt(100);
                if (i < this.m_read_frequency) {
                    Account.computeTotal(this.m_accounts);
                    if (phase == 2) {
                        ++this.m_nb_reads;
                    }
                } else if (i < this.m_read_frequency + this.m_write_frequency) {
                    Account.addInterest(this.m_accounts, 0.0f);
                    if (phase == 2) {
                        ++this.m_nb_writes;
                    }
                } else {
                    Account dst;
                    Account src;
                    int amount = this.m_random.nextInt(this.m_max) + 1;
                    if (Account.s_disjoint && this.m_nb <= this.m_accounts.length) {
                        src = this.m_accounts[this.m_random.nextInt(this.m_accounts.length / this.m_nb) * this.m_nb + this.m_id];
                        dst = this.m_accounts[this.m_random.nextInt(this.m_accounts.length / this.m_nb) * this.m_nb + this.m_id];
                    } else {
                        src = this.m_accounts[this.m_random.nextInt(this.m_accounts.length)];
                        dst = this.m_accounts[this.m_random.nextInt(this.m_accounts.length)];
                    }
                    try {
                        Account.transfer(src, dst, amount);
                        if (phase == 2) {
                            ++this.m_nb_transfers;
                        }
                    }
                    catch (OverdraftException e) {
                        System.err.println("Overdraft: " + e.getMessage());
                    }
                }
            }
        }

        @Override
        public String getStats() {
            return "T=" + this.m_nb_transfers + ", R=" + this.m_nb_reads + ", W=" + this.m_nb_writes;
        }
    }

    public static abstract class DeuceBenchmarkThread
    implements Runnable {
        private volatile int m_phase = 1;
        private int m_steps = 0;

        public void setPhase(int phase) {
            this.m_phase = phase;
        }

        public int getSteps() {
            return this.m_steps;
        }

        @Override
        public void run() {
            while (this.m_phase == 1) {
                this.step(1);
            }
            while (this.m_phase == 2) {
                this.step(2);
                ++this.m_steps;
            }
        }

        protected abstract void step(int var1);

        public abstract String getStats();
    }

    public static class OverdraftException
    extends Exception {
        public OverdraftException() {
        }

        public OverdraftException(String reason) {
            super(reason);
        }
    }

    @TransactionalObject
    public static class Account {
        static volatile boolean s_disjoint = false;
        static volatile boolean s_yield = false;
        private final String m_name;
        private float m_balance;

        public Account() {
            this.m_name = "Empty";
            this.m_balance = 0.0f;
        }

        public Account(String name) {
            this.m_name = name;
            this.m_balance = 0.0f;
        }

        public String getName() {
            return this.m_name;
        }

        public float getBalance() {
            return this.m_balance;
        }

        public void deposit(float amount) {
            this.m_balance += amount;
        }

        public void withdraw(float amount) throws OverdraftException {
            if (this.m_balance < amount) {
                throw new OverdraftException("Cannot withdraw $" + amount + " from $" + this.m_balance);
            }
            this.m_balance -= amount;
        }

        @TransactionalMethod
        public static void addInterest(Account[] accounts, float rate) {
            for (Account a : accounts) {
                a.deposit(a.getBalance() * rate);
                if (!s_yield) continue;
                Thread.yield();
            }
        }

        @TransactionalMethod
        public static double computeTotal(Account[] accounts) {
            double total = 0.0;
            for (Account a : accounts) {
                total += (double)a.getBalance();
                if (!s_yield) continue;
                Thread.yield();
            }
            return total;
        }

        @TransactionalMethod
        public static void transfer(Account src, Account dst, float amount) throws OverdraftException {
            dst.deposit(amount);
            if (s_yield) {
                Thread.yield();
            }
            src.withdraw(amount);
        }
    }
}

