/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.benchy.AbstractBenchmarkDriver;
import org.benchy.DriverParameter;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.junit.Assert;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;

public class ConcurrentUpdateWithIntrinsicLockDriver
extends AbstractBenchmarkDriver {
    @DriverParameter
    private int incCountPerThread;
    @DriverParameter
    private int threadCount;
    private IncThread[] threads;
    private intRef intRef;

    public void preRun(TestCase testCase) {
        this.threads = new IncThread[this.threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new IncThread(k);
        }
        this.intRef = new intRef();
    }

    public void run() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)(this.incCountPerThread * this.threadCount), (long)this.intRef.get());
    }

    public void postRun(TestCaseResult caseResult) {
        int transactionCount = this.incCountPerThread * this.threadCount;
        caseResult.put("transactionCount", (Object)transactionCount);
        double transactionsPerSecond = 1.0 * (double)transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)caseResult.getLongProperty("duration(ns)");
        caseResult.put("transactions/s", (Object)transactionsPerSecond);
        double transactionsPerSecondPerThread = transactionsPerSecond / (double)this.threadCount;
        caseResult.put("transactions/s/thread", (Object)transactionsPerSecondPerThread);
    }

    class intRef {
        private int value;

        intRef() {
        }

        public synchronized void inc() {
            ++this.value;
        }

        public synchronized int get() {
            return this.value;
        }
    }

    public class IncThread
    extends TestThread {
        public IncThread(int id) {
            super("IncThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < ConcurrentUpdateWithIntrinsicLockDriver.this.incCountPerThread; ++k) {
                if (k % 1000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ConcurrentUpdateWithIntrinsicLockDriver.this.intRef.inc();
            }
        }
    }
}

