/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.benchy.AbstractBenchmarkDriver;
import org.benchy.DriverParameter;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class ReadPerformanceDriver
extends AbstractBenchmarkDriver {
    @DriverParameter
    private long readCountPerThread;
    @DriverParameter
    private int threadCount;
    @DriverParameter
    private boolean readonly;
    private ReadThread[] threads;
    private IntRef ref;

    public void preRun(TestCase testCase) {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.threads = new ReadThread[this.threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new ReadThread(k);
        }
        this.ref = new IntRef();
    }

    public void postRun(TestCaseResult caseResult) {
        long transactionCount = this.readCountPerThread * (long)this.threadCount;
        caseResult.put("transactionCount", (Object)transactionCount);
        double transactionsPerSecond = 1.0 * (double)transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)caseResult.getLongProperty("duration(ns)");
        caseResult.put("transactions/second", (Object)transactionsPerSecond);
        double transactionsPerSecondPerThread = transactionsPerSecond / (double)this.threadCount;
        caseResult.put("transactions/second/thread", (Object)transactionsPerSecondPerThread);
    }

    public void run() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < ReadPerformanceDriver.this.readCountPerThread) {
                if (k % 10000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                if (ReadPerformanceDriver.this.readonly) {
                    this.readInReadonlyMode();
                } else {
                    this.readInUpdateMode();
                }
                ++k;
            }
        }

        @TransactionalMethod(readonly=true)
        public int readInReadonlyMode() {
            return ReadPerformanceDriver.this.ref.get();
        }

        @TransactionalMethod(readonly=false)
        public int readInUpdateMode() {
            return ReadPerformanceDriver.this.ref.get();
        }
    }
}

