/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.transactional.refs.IntRef;

public class CountDownCommitBarrier_StressTest {
    private AtomicLong totalInc;
    private AtomicLong commitInc;
    private int oneOfFails = 4;
    private int refCount = 50;
    private int maxPartiesCount = 5;
    private int spawnCountPerThread = 2000;
    private int spawnCount = 5;
    private IntRef[] refs;
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private ThreadPoolExecutor spawnExecutor = new ThreadPoolExecutor(this.spawnCount, this.spawnCount, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Before
    public void setUp() {
        this.commitInc = new AtomicLong();
        this.totalInc = new AtomicLong();
        this.refs = new IntRef[this.refCount];
        for (int k = 0; k < this.refCount; ++k) {
            this.refs[k] = new IntRef();
        }
    }

    @Test
    public void test() throws InterruptedException, TimeoutException {
        for (int k = 0; k < this.spawnCount; ++k) {
            this.spawnExecutor.execute(new SpawnTask("SpawnTask-" + k));
        }
        Runnable shutdownTask = new Runnable(){

            @Override
            public void run() {
                CountDownCommitBarrier_StressTest.this.spawnExecutor.shutdown();
            }
        };
        this.spawnExecutor.execute(shutdownTask);
        if (!this.spawnExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
            Assert.fail((String)"failed to complete test, it took too long");
        }
        System.out.printf("commitInc %s totalInc %s\n", this.commitInc.get(), this.totalInc.get());
        Assert.assertEquals((long)this.commitInc.get(), (long)this.sum());
    }

    public long sum() {
        long sum = 0L;
        for (int k = 0; k < this.refCount; ++k) {
            sum += (long)this.refs[k].get();
        }
        return sum;
    }

    class WorkerTask
    implements Runnable {
        final CountDownCommitBarrier countDownCommitBarrier;
        final boolean first;
        private Vector<Transaction> transactions;

        WorkerTask(boolean first, CountDownCommitBarrier countDownCommitBarrier, Vector<Transaction> transactions) {
            this.countDownCommitBarrier = countDownCommitBarrier;
            this.transactions = transactions;
            this.first = first;
        }

        @Override
        public void run() {
            try {
                ThreadLocalTransaction.clearThreadLocalTransaction();
                this.doRun();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @TransactionalMethod
        public void doRun() {
            TestUtils.sleepRandomMs((int)10);
            CountDownCommitBarrier_StressTest.this.refs[TestUtils.randomInt((int)CountDownCommitBarrier_StressTest.this.refs.length)].inc();
            TestUtils.sleepRandomMs((int)10);
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            this.transactions.add(tx);
            if (this.first && TestUtils.randomOneOf((int)CountDownCommitBarrier_StressTest.this.oneOfFails)) {
                this.countDownCommitBarrier.abort();
            }
            this.countDownCommitBarrier.joinCommitUninterruptibly(tx);
        }
    }

    public class SpawnTask
    implements Runnable {
        private String name;

        public SpawnTask(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            for (int k = 0; k < CountDownCommitBarrier_StressTest.this.spawnCountPerThread; ++k) {
                this.runOnce();
                if (k % 100 != 0) continue;
                System.out.println(this.name + " is at " + k);
            }
        }

        public void runOnce() {
            int partyCount = TestUtils.randomInt((int)CountDownCommitBarrier_StressTest.this.maxPartiesCount) + 1;
            CountDownCommitBarrier_StressTest.this.totalInc.addAndGet(partyCount);
            CountDownCommitBarrier countDownCommitBarrier = new CountDownCommitBarrier(partyCount);
            Vector<Transaction> transactions = new Vector<Transaction>();
            for (int k = 0; k < partyCount; ++k) {
                CountDownCommitBarrier_StressTest.this.executor.execute(new WorkerTask(k == 0, countDownCommitBarrier, transactions));
            }
            countDownCommitBarrier.awaitOpenUninterruptibly();
            if (countDownCommitBarrier.isCommitted()) {
                CountDownCommitBarrier_StressTest.this.commitInc.getAndAdd(partyCount);
            }
        }
    }
}

