/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.commitbarriers.JoinCommitThread;

public class CountDownCommitBarrier_countDownTest {
    @Test
    public void whenLastOne_thenBarrierOpened() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(3);
        JoinCommitThread t1 = new JoinCommitThread(barrier);
        JoinCommitThread t2 = new JoinCommitThread(barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t1, t2});
        Assert.assertTrue((boolean)barrier.isClosed());
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isCommitted());
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        t1.assertNothingThrown();
        t1.assertNothingThrown();
    }

    @Test
    public void whenNotLastOne() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(4);
        JoinCommitThread t1 = new JoinCommitThread(barrier);
        JoinCommitThread t2 = new JoinCommitThread(barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t1, t2});
        Assert.assertTrue((boolean)barrier.isClosed());
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isClosed());
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t1, t2});
    }

    @Test
    public void whenAborted_thenIgnored() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenIgnored() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        barrier.countDown();
        Assert.assertTrue((boolean)barrier.isCommitted());
    }
}

