/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.VetoCommitBarrier;
import org.multiverse.transactional.refs.IntRef;

public class VetoCommitBarrier_vetoCommitTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNoPendingTransactions() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        Assert.assertTrue((boolean)barrier.isCommitted());
    }

    @Test
    public void whenPendingTransactions() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        IntRef ref1 = new IntRef();
        IntRef ref2 = new IntRef();
        IntRef ref3 = new IntRef();
        IncThread thread1 = new IncThread(ref1, barrier);
        IncThread thread2 = new IncThread(ref2, barrier);
        IncThread thread3 = new IncThread(ref3, barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{thread1, thread2, thread3});
        TestUtils.sleepMs((long)500L);
        barrier.vetoCommit();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread1, thread2, thread3});
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{thread1.tx});
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{thread2.tx});
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{thread3.tx});
        Assert.assertEquals((long)1L, (long)ref1.get());
        Assert.assertEquals((long)1L, (long)ref2.get());
        Assert.assertEquals((long)1L, (long)ref3.get());
    }

    @Test
    public void whenBarrierCommitted_thenIgnored() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        barrier.vetoCommit();
        Assert.assertTrue((boolean)barrier.isCommitted());
    }

    @Test
    public void whenBarrierAborted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.abort();
        try {
            barrier.vetoCommit();
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    public class IncThread
    extends TestThread {
        private final IntRef ref;
        private final VetoCommitBarrier barrier;
        private Transaction tx;

        public IncThread(IntRef ref, VetoCommitBarrier barrier) {
            super("IncThread");
            this.barrier = barrier;
            this.ref = ref;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            this.tx = ThreadLocalTransaction.getThreadLocalTransaction();
            this.ref.inc();
            this.barrier.joinCommit(this.tx);
        }
    }
}

