/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.classicproblems;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.refs.IntRef;

public class DiningPhilosophersStressTest {
    private int philosopherCount = 10;
    private volatile boolean stop;
    private IntRef[] forks;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.createForks();
        TestThread[] philosopherThreads = this.createPhilosopherThreads();
        TestUtils.startAll((TestThread[])philosopherThreads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])philosopherThreads);
        this.assertAllForksHaveReturned();
    }

    public void assertAllForksHaveReturned() {
        for (IntRef fork : this.forks) {
            Assert.assertEquals((long)0L, (long)fork.get());
        }
    }

    public PhilosopherThread[] createPhilosopherThreads() {
        PhilosopherThread[] threads = new PhilosopherThread[this.philosopherCount];
        for (int k = 0; k < this.philosopherCount; ++k) {
            IntRef leftFork = this.forks[k];
            IntRef rightFork = k == this.philosopherCount - 1 ? this.forks[0] : this.forks[k + 1];
            threads[k] = new PhilosopherThread(k, leftFork, rightFork);
        }
        return threads;
    }

    public void createForks() {
        this.forks = new IntRef[this.philosopherCount];
        for (int k = 0; k < this.forks.length; ++k) {
            this.forks[k] = new IntRef(0);
        }
    }

    class PhilosopherThread
    extends TestThread {
        private final IntRef leftFork;
        private final IntRef rightFork;

        PhilosopherThread(int id, IntRef leftFork, IntRef rightFork) {
            super("PhilosopherThread-" + id);
            this.leftFork = leftFork;
            this.rightFork = rightFork;
        }

        public void doRun() {
            int k = 0;
            while (!DiningPhilosophersStressTest.this.stop) {
                if (k % 100 == 0) {
                    System.out.printf("%s at %s\n", this.getName(), k);
                }
                this.eat();
                ++k;
            }
        }

        public void eat() {
            this.takeForks();
            this.stuffHole();
            this.releaseForks();
        }

        private void stuffHole() {
            TestUtils.sleepRandomMs((int)50);
        }

        @TransactionalMethod
        public void releaseForks() {
            this.leftFork.dec();
            this.rightFork.dec();
        }

        @TransactionalMethod(maxRetries=10000)
        public void takeForks() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            if (this.leftFork.get() == 1) {
                StmUtils.retry();
            } else {
                this.leftFork.inc();
            }
            if (this.rightFork.get() == 1) {
                StmUtils.retry();
            } else {
                this.rightFork.inc();
            }
        }
    }
}

