/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.failureatomicity;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.IntRef;

public class FailureAtomicityStressTest {
    private int modifyThreadCount = 10;
    private boolean stop;
    private IntRef ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new IntRef();
        this.stop = false;
    }

    @Test
    public void test() {
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)30000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])modifyThreads);
        Assert.assertEquals((long)this.sum((ModifyThread[])modifyThreads), (long)this.ref.get());
    }

    public long sum(ModifyThread[] threads) {
        long result = 0L;
        for (ModifyThread thread : threads) {
            result += thread.writeCount;
        }
        return result;
    }

    public class ModifyThread
    extends TestThread {
        long writeCount;

        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() throws Exception {
            while (!FailureAtomicityStressTest.this.stop) {
                boolean abort;
                if (this.writeCount % 500000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.writeCount);
                }
                if (abort = TestUtils.randomOneOf((int)10)) {
                    try {
                        this.modifyButAbort();
                        Assert.fail();
                    }
                    catch (DeadTransactionException deadTransactionException) {}
                    continue;
                }
                ++this.writeCount;
                this.modify();
            }
        }

        @TransactionalMethod
        private void modify() {
            FailureAtomicityStressTest.this.ref.inc();
        }

        @TransactionalMethod
        private void modifyButAbort() {
            FailureAtomicityStressTest.this.ref.inc();
            ThreadLocalTransaction.getThreadLocalTransaction().abort();
        }
    }
}

