/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.failureatomicity;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.transactional.refs.IntRef;

public class TooManyRetriesRollbackTest {
    private IntRef modifyRef;
    private IntRef retryRef;
    private volatile boolean finished;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.modifyRef = new IntRef();
        this.retryRef = new IntRef();
        this.finished = false;
    }

    @Test
    public void test() {
        NotifyThread notifyThread = new NotifyThread();
        notifyThread.start();
        try {
            this.setAndAwaitUneven(1);
            Assert.fail();
        }
        catch (TooManyRetriesException tooManyRetriesException) {
            // empty catch block
        }
        this.finished = true;
        Assert.assertEquals((long)0L, (long)this.modifyRef.get());
        TestUtils.joinAll((TestThread[])new TestThread[]{notifyThread});
    }

    @TransactionalMethod(maxRetries=10)
    public void setAndAwaitUneven(int value) {
        this.modifyRef.set(value);
        if (this.retryRef.get() % 2 == 0) {
            StmUtils.retry();
        }
    }

    class NotifyThread
    extends TestThread {
        public NotifyThread() {
            super("NotifyThread");
        }

        public void doRun() throws Exception {
            while (!TooManyRetriesRollbackTest.this.finished) {
                TooManyRetriesRollbackTest.this.retryRef.set(TooManyRetriesRollbackTest.this.retryRef.get() + 2);
            }
        }
    }
}

