/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.granularity;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.FieldGranularity;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.WriteConflict;

public class FieldGranularityStressTest {
    public AtomicInteger conflictCounter;
    private boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.conflictCounter = new AtomicInteger();
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testFieldGranularityCausesNoWriteConflicts() {
        Pair pair = new Pair(0, 0);
        SetLeftThread leftThread = new SetLeftThread(pair);
        SetRightThread rightThread = new SetRightThread(pair);
        TestUtils.startAll((TestThread[])new TestThread[]{leftThread, rightThread});
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)30000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])new TestThread[]{leftThread, rightThread});
        Assert.assertEquals((long)leftThread.count, (long)pair.getLeft());
        Assert.assertEquals((long)rightThread.count, (long)pair.getRight());
        Assert.assertEquals((long)0L, (long)this.conflictCounter.get());
    }

    @TransactionalObject
    public static class Pair {
        @FieldGranularity
        private int left;
        @FieldGranularity
        private int right;

        public Pair(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int right) {
            this.right = right;
        }
    }

    class SetRightThread
    extends TestThread {
        final Pair pair;
        int count;

        SetRightThread(Pair pair) {
            super("SetRightThread");
            this.count = 0;
            this.pair = pair;
        }

        public void doRun() throws Exception {
            while (!FieldGranularityStressTest.this.stop) {
                this.updateRight();
                if (this.count % 5000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }

        @TransactionalMethod(readonly=false)
        public void updateRight() throws Exception {
            this.pair.setRight(this.pair.getRight() + 1);
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            try {
                tx.prepare();
            }
            catch (WriteConflict conflict) {
                conflict.printStackTrace();
                FieldGranularityStressTest.this.conflictCounter.incrementAndGet();
            }
        }
    }

    class SetLeftThread
    extends TestThread {
        final Pair pair;
        int count;

        SetLeftThread(Pair pair) {
            super("SetLeftThread");
            this.count = 0;
            this.pair = pair;
        }

        public void doRun() throws Exception {
            while (!FieldGranularityStressTest.this.stop) {
                this.updateLeft();
                if (this.count % 5000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }

        @TransactionalMethod(readonly=false)
        public void updateLeft() {
            this.pair.setLeft(this.pair.getLeft() + 1);
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            try {
                tx.prepare();
            }
            catch (WriteConflict conflict) {
                conflict.printStackTrace();
                FieldGranularityStressTest.this.conflictCounter.incrementAndGet();
            }
        }
    }
}

