/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.templates.TransactionTemplate;

public class AntWorldSnapshotStressTest {
    private Stm stm;
    private int width = 80;
    private int height = 80;
    private int testDurationMs = 60000;
    private Cell[] cells;
    private volatile boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.cells = new Cell[this.width * this.height];
        new TransactionTemplate(){

            public Object execute(Transaction tx) throws Exception {
                for (int k = 0; k < AntWorldSnapshotStressTest.this.cells.length; ++k) {
                    ((AntWorldSnapshotStressTest)AntWorldSnapshotStressTest.this).cells[k] = new Cell();
                }
                return null;
            }
        }.execute();
    }

    @Test
    public void test() {
        SnapshotThread snapshotThread = new SnapshotThread();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])new TestThread[]{snapshotThread});
        TestUtils.sleepMs((long)this.testDurationMs);
        this.stop = true;
        TestUtils.joinAll((TestThread[])new TestThread[]{snapshotThread});
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)snapshotThread.snapshotCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s snapshots/second\n", TestUtils.format((double)transactionsPerSecond));
        double averageTimePerSnapshotNs = snapshotThread.snapshotTimeNs / snapshotThread.snapshotCount;
        System.out.printf("Average time per snapshot is %s ns\n", TestUtils.format((double)averageTimePerSnapshotNs));
        System.out.printf("Average read access time per cell is %s ns\n", TestUtils.format((double)(averageTimePerSnapshotNs / (double)this.cells.length)));
    }

    @TransactionalObject
    final class Cell {
        private int value;

        Cell() {
        }

        public int getValue() {
            return this.value;
        }
    }

    class AntThread
    extends TestThread {
        AntThread() {
        }

        public void doRun() throws Exception {
            while (!AntWorldSnapshotStressTest.this.stop) {
            }
        }
    }

    class SnapshotThread
    extends TestThread {
        private long snapshotCount;
        private long snapshotTimeNs;

        public SnapshotThread() {
            super("SnapshotThread");
            this.snapshotCount = 0L;
            this.snapshotTimeNs = 0L;
        }

        public void doRun() throws Exception {
            int[] snapshot = new int[AntWorldSnapshotStressTest.this.cells.length];
            while (!AntWorldSnapshotStressTest.this.stop) {
                try {
                    long startNs = System.nanoTime();
                    this.takeSnapshot(snapshot);
                    long durationNs = System.nanoTime() - startNs;
                    this.snapshotTimeNs += durationNs;
                    ++this.snapshotCount;
                }
                catch (RuntimeException e) {
                    AntWorldSnapshotStressTest.this.stop = true;
                    throw e;
                }
            }
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        private void takeSnapshot(int[] snapshot) {
            for (int k = 0; k < snapshot.length; ++k) {
                snapshot[k] = AntWorldSnapshotStressTest.this.cells[k].getValue();
            }
        }
    }
}

