/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.IntRef;

public class DirtyReadStressTest {
    private IntRef ref;
    private int readThreadCount = 10;
    private int modifyThreadCount = 2;
    private volatile boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new IntRef(0);
        this.stop = false;
    }

    @Test
    public void test() {
        TestThread[] modifyThreads = new FailingModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new FailingModifyThread(k);
        }
        TestThread[] readerThread = new ReadThread[this.readThreadCount];
        for (int k = 0; k < this.readThreadCount; ++k) {
            readerThread[k] = new ReadThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.startAll((TestThread[])readerThread);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])readerThread);
    }

    class ReadThread
    extends TestThread {
        public ReadThread(int threadId) {
            super("ReadThread-" + threadId);
        }

        public void doRun() {
            int k = 0;
            while (!DirtyReadStressTest.this.stop) {
                switch (k % 4) {
                    case 0: {
                        this.observeUsingReadonlyTransaction();
                        break;
                    }
                    case 1: {
                        this.observeUsingReadtrackingReadonlyTransaction();
                        break;
                    }
                    case 2: {
                        this.observeUsingUpdateTransaction();
                        break;
                    }
                    case 3: {
                        this.observeUsingReadtrackingUpdateTransaction();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++k;
                TestUtils.sleepRandomMs((int)5);
            }
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        private void observeUsingReadonlyTransaction() {
            this.observe();
        }

        @TransactionalMethod(readonly=false, trackReads=false)
        private void observeUsingUpdateTransaction() {
            this.observe();
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        private void observeUsingReadtrackingReadonlyTransaction() {
            this.observe();
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        private void observeUsingReadtrackingUpdateTransaction() {
            this.observe();
        }

        private void observe() {
            if (DirtyReadStressTest.this.ref.get() % 2 != 0) {
                Assert.fail();
            }
        }
    }

    class FailingModifyThread
    extends TestThread {
        public FailingModifyThread(int threadId) {
            super("FailingModifyThread-" + threadId);
        }

        public void doRun() {
            while (!DirtyReadStressTest.this.stop) {
                try {
                    this.modify();
                    Assert.fail();
                }
                catch (DeadTransactionException deadTransactionException) {
                    // empty catch block
                }
                TestUtils.sleepRandomMs((int)10);
            }
        }

        @TransactionalMethod
        private void modify() {
            DirtyReadStressTest.this.ref.inc();
            TestUtils.sleepRandomMs((int)30);
            ThreadLocalTransaction.getThreadLocalTransaction().abort();
        }
    }
}

