/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class WriteSkewStressTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void simpleTestWithWriteSkewDetectionDisabledRepeated() {
        for (int k = 0; k < 100; ++k) {
            this.simpleTestWithWriteSkewAllowed();
        }
    }

    public void simpleTestWithWriteSkewAllowed() {
        IntRef from1 = new IntRef(100);
        IntRef from2 = new IntRef(0);
        IntRef to1 = new IntRef();
        IntRef to2 = new IntRef();
        TransferThread t1 = new TransferThread(from1, from2, to1, true);
        TransferThread t2 = new TransferThread(from2, from1, to2, true);
        t1.start();
        t2.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        int sum = from1.get() + from2.get();
        Assert.assertTrue((sum < 0 ? 1 : 0) != 0);
    }

    @Test
    public void simpleWithoutWriteSkew() {
        for (int k = 0; k < 100; ++k) {
            this.simpleTestWithoutWriteSkew();
        }
    }

    public void simpleTestWithoutWriteSkew() {
        IntRef from1 = new IntRef(100);
        IntRef from2 = new IntRef(0);
        IntRef to1 = new IntRef(0);
        IntRef to2 = new IntRef(0);
        TransferThread t1 = new TransferThread(from1, from2, to1, false);
        TransferThread t2 = new TransferThread(from2, from1, to2, false);
        t2.start();
        t1.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        ThreadLocalTransaction.clearThreadLocalTransaction();
        int sum = from1.get() + from2.get();
        Assert.assertTrue((String)("sumRefs " + sum), (sum >= 0 ? 1 : 0) != 0);
    }

    private class TransferThread
    extends TestThread {
        final IntRef from1;
        final IntRef from2;
        final IntRef to;
        final boolean writeSkewAllowed;

        private TransferThread(IntRef from1, IntRef from2, IntRef to, boolean writeSkewAllowed) {
            this.from1 = from1;
            this.from2 = from2;
            this.to = to;
            this.writeSkewAllowed = writeSkewAllowed;
        }

        public void doRun() throws Exception {
            if (this.writeSkewAllowed) {
                this.doRunWriteSkewAllowed();
            } else {
                this.doRunWriteSkewDisallowed();
            }
        }

        @TransactionalMethod(trackReads=true, writeSkew=false)
        public void doRunWriteSkewDisallowed() throws Exception {
            this.doIt();
        }

        @TransactionalMethod(trackReads=true, writeSkew=true)
        public void doRunWriteSkewAllowed() throws Exception {
            this.doIt();
        }

        private void doIt() {
            if (this.from1.get() + this.from2.get() >= 100) {
                this.from1.dec(100);
                this.to.inc(100);
            }
            TestUtils.sleepMs((long)200L);
        }
    }
}

