/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.liveness;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class DeadlockStressTest {
    private volatile boolean stop;
    private int refCount = 100;
    private int threadCount = 10;
    private IntRef[] refs;
    private ChangeThread[] threads;

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        int k;
        this.refs = new IntRef[this.refCount];
        for (k = 0; k < this.refCount; ++k) {
            this.refs[k] = new IntRef();
        }
        this.threads = new ChangeThread[this.threadCount];
        for (k = 0; k < this.threadCount; ++k) {
            this.threads[k] = new ChangeThread(k);
        }
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])this.threads);
    }

    public class ChangeThread
    extends TestThread {
        public ChangeThread(int id) {
            super("ChangeThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while (!DeadlockStressTest.this.stop) {
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.transaction();
                ++k;
            }
        }

        @TransactionalMethod
        public void transaction() {
            for (int k = 0; k < DeadlockStressTest.this.refs.length; ++k) {
                if (TestUtils.randomInt((int)3) != 0) continue;
                int index = TestUtils.randomInt((int)DeadlockStressTest.this.refs.length);
                if (TestUtils.randomInt((int)5) != 0) continue;
                DeadlockStressTest.this.refs[index].inc();
            }
        }
    }
}

