/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class ConnectionPoolStressTest {
    private int poolsize = 8;
    private int threadCount = 10;
    private int useCount = 1000;
    private ConnectionPool pool;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.pool = new ConnectionPool(this.poolsize);
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)this.poolsize, (long)this.pool.size());
    }

    private WorkerThread[] createThreads() {
        WorkerThread[] threads = new WorkerThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WorkerThread(k);
        }
        return threads;
    }

    class WorkerThread
    extends TestThread {
        public WorkerThread(int id) {
            super("WorkerThread-" + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() throws Exception {
            for (int k = 0; k < ConnectionPoolStressTest.this.useCount; ++k) {
                if (k % 100 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                Connection c = ConnectionPoolStressTest.this.pool.takeConnection();
                Assert.assertNotNull((Object)c);
                c.startUsing();
                try {
                    TestUtils.sleepRandomMs((int)50);
                    continue;
                }
                finally {
                    c.stopUsing();
                    ConnectionPoolStressTest.this.pool.returnConnection(c);
                }
            }
        }
    }

    static class Connection {
        AtomicInteger users = new AtomicInteger();

        Connection() {
        }

        void startUsing() {
            if (!this.users.compareAndSet(0, 1)) {
                Assert.fail();
            }
        }

        void stopUsing() {
            if (!this.users.compareAndSet(1, 0)) {
                Assert.fail();
            }
        }
    }

    @TransactionalObject
    static class ConnectionPool {
        final TransactionalLinkedList<Connection> deque = new TransactionalLinkedList();

        ConnectionPool(int poolsize) {
            this.fill(poolsize);
        }

        private void fill(int poolsize) {
            for (int k = 0; k < poolsize; ++k) {
                this.deque.add((Object)new Connection());
            }
        }

        @TransactionalMethod(maxRetries=10000)
        Connection takeConnection() throws InterruptedException {
            return (Connection)this.deque.takeFirst();
        }

        void returnConnection(Connection c) {
            try {
                this.deque.putLast((Object)c);
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
        }

        int size() {
            return this.deque.size();
        }
    }
}

