/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.integrationtests.Ref;

public class PingPongStressTest {
    private volatile boolean stop = false;
    private int threadCount = 2;
    private Ref ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new Ref(0);
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)this.sum((PingPongThread[])threads), (long)this.ref.get());
    }

    private PingPongThread[] createThreads() {
        PingPongThread[] threads = new PingPongThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new PingPongThread(k);
        }
        return threads;
    }

    private long sum(PingPongThread[] threads) {
        long result = 0L;
        for (PingPongThread t : threads) {
            result += (long)t.count;
        }
        return result;
    }

    private class PingPongThread
    extends TestThread {
        private int id;
        private int count;

        public PingPongThread(int id) {
            super("PingPongThread-" + id);
            this.id = id;
        }

        public void doRun() {
            int expected = this.id;
            while (!PingPongStressTest.this.stop) {
                if (this.count % 100000 == 0) {
                    System.out.println(this.getName() + " " + this.count);
                }
                PingPongStressTest.this.ref.await(expected);
                PingPongStressTest.this.ref.inc();
                expected += PingPongStressTest.this.threadCount;
                ++this.count;
            }
        }
    }
}

