/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

public class DefaultTransactionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = new AlphaStm();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    @Ignore
    public void testBlocking() {
    }

    @Test
    public void testConstruction() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().build();
        final AtomicReference holder = new AtomicReference();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                ManualRef ref = new ManualRef(DefaultTransactionTest.this.stm, 20);
                holder.set(ref);
                return null;
            }
        }.execute();
        Assert.assertEquals((long)20L, (long)((ManualRef)((Object)holder.get())).get(this.stm));
    }

    @Test
    public void testUpdate() {
        final ManualRef ref = new ManualRef(this.stm);
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().build();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                ref.set((AlphaTransaction)tx, 20);
                return null;
            }
        }.execute();
        Assert.assertEquals((long)20L, (long)ref.get(this.stm));
    }
}

