/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.NoTransactionAllowedException;
import org.multiverse.api.exceptions.NoTransactionFoundException;
import org.multiverse.templates.TransactionTemplate;

public class TransactionTemplate_propagationTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNeverAndTransactionAvailable_thenNoTransactionAllowedException() {
        Transaction otherTx = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)otherTx);
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Never).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            new TransactionTemplate(transactionFactory){

                public Object execute(Transaction tx) throws Exception {
                    task.run();
                    return null;
                }
            }.execute();
            Assert.fail();
        }
        catch (NoTransactionAllowedException expected) {
            // empty catch block
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{task});
        TestUtils.assertIsActive((Transaction[])new Transaction[]{otherTx});
        Assert.assertSame((Object)otherTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void whenNeverAndNoTransactionAvailable() {
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Never).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{task});
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void whenMandatoryAndNoTransactionAvailable_thenNoTransactionFoundException() {
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Mandatory).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            new TransactionTemplate(transactionFactory){

                public Object execute(Transaction tx) throws Exception {
                    task.run();
                    return null;
                }
            }.execute();
            Assert.fail();
        }
        catch (NoTransactionFoundException noTransactionFoundException) {
            // empty catch block
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{task});
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void whenMandatoryAndTransactionAvailable_thenExistingTransactionUsed() {
        final Transaction otherTx = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)otherTx);
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Mandatory).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertSame((Object)otherTx, (Object)tx);
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Assert.assertSame((Object)otherTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{otherTx});
    }

    @Test
    public void whenRequiresAndNoTransactionAvailable_thenNewTransactionUsed() {
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Requires).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertNotNull((Object)tx);
                TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{ThreadLocalTransaction.getThreadLocalTransaction()});
    }

    @Test
    public void whenRequiresAndTransactionAvailable_thenExistingTransactionUsed() {
        final Transaction otherTx = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)otherTx);
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Requires).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertSame((Object)otherTx, (Object)tx);
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Assert.assertSame((Object)otherTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{otherTx});
    }

    @Test
    public void whenRequiresNewAndNoTransactionAvailable_thenNewTransactionCreated() {
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.RequiresNew).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertNotNull((Object)tx);
                TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void whenRequiresNewAndTransactionAvailable_thenExistingTransactionSuspended() {
        final Transaction otherTx = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)otherTx);
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.RequiresNew).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertNotSame((Object)otherTx, (Object)tx);
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Assert.assertSame((Object)otherTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{otherTx});
    }

    @Test
    public void whenSupportsAndTransactionAvailable() {
        final Transaction otherTx = this.stm.getTransactionFactoryBuilder().build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)otherTx);
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Supports).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertSame((Object)otherTx, (Object)tx);
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Assert.assertSame((Object)otherTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{otherTx});
    }

    @Test
    public void whenSupportsAndNoTransactionAvailable() {
        TransactionFactory transactionFactory = this.stm.getTransactionFactoryBuilder().setPropagationLevel(PropagationLevel.Supports).build();
        final Runnable task = (Runnable)Mockito.mock(Runnable.class);
        new TransactionTemplate(transactionFactory){

            public Object execute(Transaction tx) throws Exception {
                Assert.assertNull((Object)tx);
                task.run();
                return null;
            }
        }.execute();
        ((Runnable)Mockito.verify((Object)task)).run();
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }
}

