/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.transactional.refs.BasicRef;
import org.multiverse.transactional.refs.IntRef;
import org.multiverse.transactional.refs.Ref;

public class TransactionalMethod_TimeoutLongTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenTimeout() {
        BasicRef ref = new BasicRef();
        try {
            this.tryAwaitNonNull((Ref)ref);
            Assert.fail();
        }
        catch (RetryTimeoutException retryTimeoutException) {
            // empty catch block
        }
    }

    @TransactionalMethod(timeout=1L)
    public void tryAwaitNonNull(Ref ref) {
        if (ref.isNull()) {
            StmUtils.retry();
        }
    }

    @Test
    public void whenSomeWaitingNeeded() {
        final IntRef ref = new IntRef();
        TestThread incThread = new TestThread(){

            public void doRun() throws Exception {
                for (int k = 0; k < 100; ++k) {
                    ref.inc();
                    TestUtils.sleepMs((long)50L);
                }
            }
        };
        incThread.start();
        this.tryAwaitFiveSeconds(ref, 50);
        System.out.println("Waiting on incthread to complete");
        TestUtils.joinAll((TestThread[])new TestThread[]{incThread});
    }

    @TransactionalMethod(timeout=5L, maxRetries=100000)
    public void tryAwaitFiveSeconds(IntRef ref, int minvalue) {
        if (ref.get() < minvalue) {
            System.out.println("ref.get: " + ref.get() + " and waiting for: " + minvalue);
            StmUtils.retry();
        }
    }

    @Test
    public void multipleWakeupsButNotEnough() {
        final IntRef ref = new IntRef();
        TestThread incThread = new TestThread(){

            public void doRun() throws Exception {
                for (int k = 0; k < 70; ++k) {
                    ref.inc();
                    TestUtils.sleepMs((long)100L);
                }
            }
        };
        incThread.start();
        try {
            this.tryAwaitFiveSeconds(ref, 100000);
            Assert.fail();
        }
        catch (RetryTimeoutException retryTimeoutException) {
            // empty catch block
        }
        System.out.println("Waiting on incthread to complete");
        TestUtils.joinAll((TestThread[])new TestThread[]{incThread});
    }
}

