/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.stms.alpha.AlphaStm;

public class StaticInnerClassTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void publicConstructor() {
        InnerClassWithPublicConstructor foo = new InnerClassWithPublicConstructor(1);
        Assert.assertEquals((long)1L, (long)foo.get());
        foo.set(10);
        Assert.assertEquals((long)10L, (long)foo.get());
    }

    @Test
    public void privateConstructor() {
        StaticInnerClassWithPrivateConstructor privateConstructor = new StaticInnerClassWithPrivateConstructor(1);
        Assert.assertEquals((long)1L, (long)privateConstructor.get());
    }

    @Test
    public void protectedConstructor() {
        StaticInnerClassWithProtectedConstructor x = new StaticInnerClassWithProtectedConstructor(1);
        Assert.assertEquals((long)1L, (long)x.get());
    }

    @Test
    public void packageFriendlyConstructor() {
        StaticInnerClassWithPackageFriendlyConstructor x = new StaticInnerClassWithPackageFriendlyConstructor(1);
        Assert.assertEquals((long)1L, (long)x.get());
    }

    @TransactionalObject
    static class StaticInnerClassWithPackageFriendlyConstructor {
        private int value;

        private StaticInnerClassWithPackageFriendlyConstructor(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class StaticInnerClassWithProtectedConstructor {
        private int value;

        private StaticInnerClassWithProtectedConstructor(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class StaticInnerClassWithPrivateConstructor {
        private int value;

        private StaticInnerClassWithPrivateConstructor(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class InnerClassWithPublicConstructor {
        private int value;

        public InnerClassWithPublicConstructor(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }
}

