/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.annotations.TransactionalConstructor;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;

public class TransactionalConstructor_settingsTest {
    @Test
    public void readonlySettings() {
        new ReadonlyExplicitlyEnabled();
        new ReadonlyExplicitlyDisabled();
    }

    @Test
    public void defaultSettings() {
        new DefaultSettingsTransactionalConstructor();
    }

    @Test
    public void readTracking() {
        new DisabledReadTracking();
        new EnabledReadTracking();
    }

    @Test
    public void allowWriteSkew() {
        new disallowedWriteSkew();
        new allowedWriteSkew();
    }

    public class allowedWriteSkew {
        @TransactionalConstructor(writeSkew=true)
        public allowedWriteSkew() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isWriteSkewAllowed());
        }
    }

    public class disallowedWriteSkew {
        @TransactionalConstructor(trackReads=true, writeSkew=false)
        public disallowedWriteSkew() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isWriteSkewAllowed());
        }
    }

    public class EnabledReadTracking {
        @TransactionalConstructor(trackReads=true)
        public EnabledReadTracking() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }
    }

    public class DisabledReadTracking {
        @TransactionalConstructor(trackReads=false)
        public DisabledReadTracking() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        }
    }

    public class DefaultSettingsTransactionalConstructor {
        @TransactionalConstructor
        public DefaultSettingsTransactionalConstructor() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadonly());
            Assert.assertEquals((long)0L, (long)tx.getConfiguration().getMaxRetries());
            Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
            Assert.assertTrue((boolean)tx.getConfiguration().isWriteSkewAllowed());
        }
    }

    public class ReadonlyExplicitlyDisabled {
        @TransactionalConstructor(readonly=false)
        ReadonlyExplicitlyDisabled() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadonly());
        }
    }

    public class ReadonlyExplicitlyEnabled {
        @TransactionalConstructor(readonly=true)
        ReadonlyExplicitlyEnabled() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)tx.getConfiguration().isReadonly());
        }
    }
}

