/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalObject_ChainOfMethodsTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void chainOfMethodsOfSameType() {
        SomeTypeMethodChain ref1 = new SomeTypeMethodChain(null);
        SomeTypeMethodChain ref2 = new SomeTypeMethodChain(ref1);
        SomeTypeMethodChain ref3 = new SomeTypeMethodChain(ref2);
        Assert.assertNull((Object)ref1.getNext());
        Assert.assertSame((Object)ref1, (Object)ref2.getNext());
        Assert.assertNull((Object)ref2.getNextNext());
        Assert.assertSame((Object)ref2, (Object)ref3.getNext());
        Assert.assertSame((Object)ref1, (Object)ref3.getNextNext());
        Assert.assertNull((Object)ref3.getNextNextNext());
    }

    @TransactionalObject
    private static class SomeTypeMethodChain {
        SomeTypeMethodChain next;

        private SomeTypeMethodChain(SomeTypeMethodChain next) {
            this.next = next;
        }

        public SomeTypeMethodChain getNextNext() {
            return this.getNext().getNext();
        }

        public SomeTypeMethodChain getNextNextNext() {
            return this.getNext().getNext().getNext();
        }

        public SomeTypeMethodChain getNext() {
            return this.next;
        }

        public void setNext(SomeTypeMethodChain next) {
            this.next = next;
        }
    }
}

