/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.fieldaccess.ObjectWithStaticInitializer;
import org.multiverse.transactional.refs.IntRef;

public class TransactionalObject_ConstructorTest {
    private AlphaStm stm;
    private static final AtomicLong constructorInitCounter = new AtomicLong();

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructorWithReadFirst() {
        ConstructorWithReadFirst object = new ConstructorWithReadFirst();
        Assert.assertEquals((long)0L, (long)object.getField());
    }

    @Test
    public void testNoArgConstructor() {
        NoArgConstructor o = new NoArgConstructor();
        Assert.assertEquals((long)10L, (long)o.getValue());
    }

    @Test
    public void testEmptyConstructor() {
        long version = this.stm.getVersion();
        testEmptyConstructor o = new testEmptyConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testNoConstructor() {
        long version = this.stm.getVersion();
        NoConstructor noConstructor = new NoConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testOneArgConstructor() {
        long version = this.stm.getVersion();
        OneArgConstructor o = new OneArgConstructor(10);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.getA());
    }

    @Test
    public void testTwoArgConstructor() {
        long version = this.stm.getVersion();
        TwoArgConstructor o = new TwoArgConstructor(20, 8);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)20L, (long)o.getA());
        Assert.assertEquals((long)8L, (long)o.getB());
    }

    @Test
    public void testFiveArgConstructor() {
        long version = this.stm.getVersion();
        FiveArgConstructor fiveArgConstructor = new FiveArgConstructor(10, 40, 2, 9, -1);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)fiveArgConstructor.getA());
        Assert.assertEquals((long)40L, (long)fiveArgConstructor.getB());
        Assert.assertEquals((long)2L, (long)fiveArgConstructor.getC());
        Assert.assertEquals((long)9L, (long)fiveArgConstructor.getD());
        Assert.assertEquals((long)-1L, (long)fiveArgConstructor.getE());
    }

    @Test
    public void testVarArgsConstructor() {
        long version = this.stm.getVersion();
        VarArgConstructor varArgConstructor = new VarArgConstructor(1, 2, 3, 4);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])varArgConstructor.getArgs());
    }

    @Test
    public void testArrayConstructor() {
        long version = this.stm.getVersion();
        int[] args = new int[]{1, 2, 3, 4};
        ArrayConstructor o = new ArrayConstructor(args);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)args, (Object)o.getArgs());
    }

    @Test
    public void testTransactionalObjectConstructor() {
        IntRef intValue2 = new IntRef(10);
        long version = this.stm.getVersion();
        TransactionalObjectConstructor o = new TransactionalObjectConstructor(intValue2);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)intValue2, (Object)o.getIntValue());
    }

    @Test
    public void testNormalRefConstructor() {
        String value = "foo";
        long version = this.stm.getVersion();
        NormalRefConstructor o = new NormalRefConstructor(value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)value, (Object)o.getValue());
    }

    @Test
    public void testCreateTxObjectInConstructor() {
        long startVersion = this.stm.getVersion();
        CreateTxObjectInConstructor o = new CreateTxObjectInConstructor(10);
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)o.getValue());
    }

    @Test
    public void testExceptionIsThrownInsideConstructor() {
        long version = this.stm.getVersion();
        try {
            new ExceptionIsThrownInsideConstructor();
            Assert.fail();
        }
        catch (MyException myException) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void constructorWithExplicitSuperCallingConstructor() {
        long version = this.stm.getVersion();
        TxObjectWithNoArgSuperCallingConstructor o = new TxObjectWithNoArgSuperCallingConstructor();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void constructorWithSuperCallingConstructor() {
        ConstructorThatCallsSuper object = new ConstructorThatCallsSuper(10);
        Assert.assertEquals((long)10L, (long)object.value);
    }

    @Test
    public void constructorThatCallsThis() {
        ThisCallingConstructor c = new ThisCallingConstructor();
        Assert.assertEquals((long)25L, (long)c.getValue());
    }

    @Test
    public void finalFieldOnTxObject() {
        long version = this.stm.getVersion();
        TxObjectWithFinalField o = new TxObjectWithFinalField(10);
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)o.value);
    }

    @Test
    public void finalFieldIsAtomicObject() {
        IntRef value = new IntRef(100);
        long version = this.stm.getVersion();
        TxObjectWithOtherTxObjectAsFinalField o = new TxObjectWithOtherTxObjectAsFinalField(value);
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)value, (Object)o.value);
    }

    @Test
    public void finalFieldIsTxObjectAndCreatedInConstructor() {
        long version = this.stm.getVersion();
        TxObjectWithFinalRefThatIsCreatedInsideConstructor o = new TxObjectWithFinalRefThatIsCreatedInsideConstructor();
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)10L, (long)o.value.get());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void testStaticInitializer() {
        ObjectWithStaticInitializer o = new ObjectWithStaticInitializer(10);
        Assert.assertEquals((long)100L, (long)ObjectWithStaticInitializer.staticValue);
        Assert.assertEquals((long)10L, (long)o.getValue());
    }

    @Test
    public void testInstanceInitializer() {
        constructorInitCounter.set(0L);
        InstanceInitializer foo = new InstanceInitializer();
        Assert.assertEquals((long)1L, (long)constructorInitCounter.get());
        Assert.assertEquals((long)1L, (long)foo.getInitCounter());
        Assert.assertEquals((long)1L, (long)constructorInitCounter.get());
    }

    static /* synthetic */ AtomicLong access$000() {
        return constructorInitCounter;
    }

    @TransactionalObject
    public static class InstanceInitializer {
        long initCounter = TransactionalObject_ConstructorTest.access$000().incrementAndGet();

        public long getInitCounter() {
            return this.initCounter;
        }
    }

    @TransactionalObject
    static class TxObjectWithFinalRefThatIsCreatedInsideConstructor {
        final IntRef value = new IntRef(10);
    }

    @TransactionalObject
    static class TxObjectWithOtherTxObjectAsFinalField {
        final IntRef value;

        TxObjectWithOtherTxObjectAsFinalField(IntRef value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class TxObjectWithFinalField {
        final int value;

        TxObjectWithFinalField(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class ThisCallingConstructor {
        int value;

        public ThisCallingConstructor() {
            this(25);
        }

        public ThisCallingConstructor(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class ConstructorThatCallsSuper
    extends Super {
        public ConstructorThatCallsSuper(int value) {
            super(value);
        }
    }

    static class Super {
        int value;

        Super(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    static class TxObjectWithNoArgSuperCallingConstructor {
        private int value;

        TxObjectWithNoArgSuperCallingConstructor() {
        }
    }

    static class MyException
    extends RuntimeException {
        MyException() {
        }
    }

    @TransactionalObject
    static class ExceptionIsThrownInsideConstructor {
        private int field;

        ExceptionIsThrownInsideConstructor() {
            throw new MyException();
        }
    }

    @TransactionalObject
    static class CreateTxObjectInConstructor {
        private IntRef value;

        CreateTxObjectInConstructor(int i) {
            this.value = new IntRef(i);
        }

        public IntRef getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class NormalRefConstructor {
        String value;

        NormalRefConstructor(String intValue2) {
            this.value = intValue2;
        }

        public String getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    static class TransactionalObjectConstructor {
        IntRef intValue;

        TransactionalObjectConstructor(IntRef intValue2) {
            this.intValue = intValue2;
        }

        public IntRef getIntValue() {
            return this.intValue;
        }
    }

    @TransactionalObject
    static class ArrayConstructor {
        private int[] args;

        ArrayConstructor(int[] args) {
            this.args = args;
        }

        public int[] getArgs() {
            return this.args;
        }
    }

    @TransactionalObject
    static class VarArgConstructor {
        private int[] args;

        VarArgConstructor(int ... args) {
            this.args = args;
        }

        public int[] getArgs() {
            return this.args;
        }
    }

    @TransactionalObject
    static class FiveArgConstructor {
        private int a;
        private int b;
        private int c;
        private int d;
        private int e;

        public FiveArgConstructor(int a, int b, int c, int d, int e) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        public int getD() {
            return this.d;
        }

        public int getE() {
            return this.e;
        }
    }

    @TransactionalObject
    static class TwoArgConstructor {
        private int a;
        private int b;

        public TwoArgConstructor(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    @TransactionalObject
    static class OneArgConstructor {
        private int a;

        public OneArgConstructor(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }
    }

    @TransactionalObject
    static class NoConstructor {
        private int value;

        NoConstructor() {
        }
    }

    @TransactionalObject
    static class testEmptyConstructor {
        private int value;
    }

    @TransactionalObject
    static class NoArgConstructor {
        private int value = 10;

        public int getValue() {
            return this.value;
        }
    }

    @TransactionalObject
    public class ConstructorWithReadFirst {
        private int field;

        public ConstructorWithReadFirst() {
            this.field *= 2;
        }

        public int getField() {
            return this.field;
        }
    }
}

