/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

public class TransactionalObject_ExcludeFieldTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void excludeOneOfTheFields() {
        int excludedValue = 10;
        int includedValue = 20;
        long version = this.stm.getVersion();
        ExcludeOneOfTheFields o = new ExcludeOneOfTheFields(excludedValue, includedValue);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)excludedValue, (long)o.excluded);
        Assert.assertEquals((long)excludedValue, (long)o.getExcluded());
        Assert.assertEquals((long)includedValue, (long)o.getIncluded());
    }

    @Test
    public void excludeOnlyField() {
        long version = this.stm.getVersion();
        int value = 1;
        ExcludeOnlyField o = new ExcludeOnlyField(value);
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.field);
        Assert.assertEquals((long)1L, (long)o.getField());
    }

    @Test
    public void excludeOnNonTransactionalObjectDoesNotCauseProblems() {
        long version = this.stm.getVersion();
        ExcludeOnNonTransactionalObject o = new ExcludeOnNonTransactionalObject();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)(o instanceof AlphaTransactionalObject));
    }

    @Test
    public void excludeStaticFieldDoesntCauseProblems() {
        int staticField = 10;
        int instanceField = 20;
        long version = this.stm.getVersion();
        ExcludeStaticField o = new ExcludeStaticField(instanceField, staticField);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)(o instanceof AlphaTransactionalObject));
        Assert.assertEquals((long)staticField, (long)ExcludeStaticField.staticField);
        Assert.assertEquals((long)staticField, (long)ExcludeStaticField.getStaticField());
        Assert.assertEquals((long)staticField, (long)o.getStaticFieldThroughInstance());
        Assert.assertEquals((long)instanceField, (long)o.getInstanceField());
    }

    @TransactionalObject
    static class ExcludeStaticField {
        @NonTransactional
        private static int staticField;
        private int instanceField;

        ExcludeStaticField(int instanceField, int newStaticField) {
            this.instanceField = instanceField;
            staticField = newStaticField;
        }

        public int getInstanceField() {
            return this.instanceField;
        }

        public static int getStaticField() {
            return staticField;
        }

        public int getStaticFieldThroughInstance() {
            return staticField;
        }
    }

    static class ExcludeOnNonTransactionalObject {
        @NonTransactional
        private int field;

        ExcludeOnNonTransactionalObject() {
        }
    }

    @TransactionalObject
    static class ExcludeOnlyField {
        @NonTransactional
        int field;

        ExcludeOnlyField(int field) {
            this.field = field;
        }

        public int getField() {
            return this.field;
        }
    }

    @TransactionalObject
    public static class ExcludeOneOfTheFields {
        int included;
        @NonTransactional
        int excluded;

        ExcludeOneOfTheFields(int excluded, int included) {
            this.excluded = excluded;
            this.included = included;
        }

        public int getExcluded() {
            return this.excluded;
        }

        public int getIncluded() {
            return this.included;
        }
    }
}

