/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldgranularity;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.FieldGranularity;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;
import org.multiverse.transactional.refs.BasicRef;
import org.multiverse.transactional.refs.BooleanRef;
import org.multiverse.transactional.refs.ByteRef;
import org.multiverse.transactional.refs.CharRef;
import org.multiverse.transactional.refs.DoubleRef;
import org.multiverse.transactional.refs.FloatRef;
import org.multiverse.transactional.refs.IntRef;
import org.multiverse.transactional.refs.LongRef;
import org.multiverse.transactional.refs.ShortRef;

public class FieldGranularityTransformerTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void privateField() {
        Class<PrivateField> clazz = PrivateField.class;
        PrivateField field = new PrivateField(10);
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", IntRef.class);
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        long version = this.stm.getVersion();
        field.setValue(field.getValue() + 1);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)field.getValue());
    }

    @Test
    public void protectedField() {
        ProtectedField field = new ProtectedField(10);
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", IntRef.class);
        long version = this.stm.getVersion();
        field.setValue(field.getValue() + 1);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)field.getValue());
    }

    @Test
    public void publicField() {
        PublicField field = new PublicField(10);
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", IntRef.class);
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        long version = this.stm.getVersion();
        field.setValue(field.getValue() + 1);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)field.getValue());
    }

    @Test
    public void packageFriendlyField() {
        PackageFriendlyField field = new PackageFriendlyField(10);
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", IntRef.class);
        long version = this.stm.getVersion();
        field.setValue(field.getValue() + 1);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)field.getValue());
    }

    @Test
    public void intField_structure() {
        IntField field = new IntField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", IntRef.class);
    }

    @Test
    public void intField_Usage() {
        IntField field = new IntField();
        Assert.assertEquals((long)0L, (long)field.getValue());
        field.setValue(100);
        Assert.assertEquals((long)100L, (long)field.getValue());
        field = new IntField(200);
        Assert.assertEquals((long)200L, (long)field.getValue());
    }

    @Test
    public void floatField_structure() {
        FloatField field = new FloatField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", FloatRef.class);
    }

    @Test
    public void floatField_Usage() {
        FloatField field = new FloatField();
        Assert.assertTrue((boolean)new Float(0.0f).equals(Float.valueOf(field.getValue())));
        field.setValue(100.0f);
        Assert.assertTrue((boolean)new Float(100.0f).equals(Float.valueOf(field.getValue())));
        field = new FloatField(200.0f);
        Assert.assertTrue((boolean)new Float(200.0f).equals(Float.valueOf(field.getValue())));
    }

    @Test
    public void booleanField_structure() {
        BooleanField field = new BooleanField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", BooleanRef.class);
    }

    @Test
    public void booleanField_usage() {
        BooleanField field = new BooleanField();
        Assert.assertFalse((boolean)field.getValue());
        field.setValue(true);
        Assert.assertTrue((boolean)field.getValue());
        field = new BooleanField(true);
        Assert.assertTrue((boolean)field.getValue());
    }

    @Test
    public void byteField_structure() {
        ByteField field = new ByteField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", ByteRef.class);
    }

    @Test
    public void byteField_Usage() {
        ByteField field = new ByteField();
        Assert.assertEquals((long)0L, (long)field.getValue());
        field.setValue((byte)10);
        Assert.assertEquals((long)10L, (long)field.getValue());
        field = new ByteField(50);
        Assert.assertEquals((long)50L, (long)field.getValue());
    }

    @Test
    public void charField_structure() {
        CharField field = new CharField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", CharRef.class);
    }

    @Test
    public void charField_Usage() {
        CharField field = new CharField();
        Assert.assertEquals((long)0L, (long)field.getValue());
        field.setValue('a');
        Assert.assertEquals((long)97L, (long)field.getValue());
        field = new CharField('b');
        Assert.assertEquals((long)98L, (long)field.getValue());
    }

    @Test
    public void longField_structure() {
        LongField field = new LongField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", LongRef.class);
    }

    @Test
    public void longField_Usage() {
        LongField field = new LongField();
        Assert.assertEquals((long)0L, (long)field.getValue());
        field.setValue(100L);
        Assert.assertEquals((long)100L, (long)field.getValue());
        field = new LongField(200L);
        Assert.assertEquals((long)200L, (long)field.getValue());
    }

    @Test
    public void doubleField_structure() {
        DoubleField field = new DoubleField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", DoubleRef.class);
    }

    @Test
    public void doubleField_Usage() {
        DoubleField field = new DoubleField();
        Assert.assertTrue((boolean)new Double(0.0).equals(field.getValue()));
        field.setValue(100.0);
        Assert.assertTrue((boolean)new Double(100.0).equals(field.getValue()));
        field = new DoubleField(200);
        Assert.assertTrue((boolean)new Double(200.0).equals(field.getValue()));
    }

    @Test
    public void shortField_structure() {
        ShortField field = new ShortField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", ShortRef.class);
    }

    @Test
    public void shortField_Usage() {
        ShortField field = new ShortField();
        Assert.assertEquals((long)0L, (long)field.getValue());
        field.setValue((short)100);
        Assert.assertEquals((long)100L, (long)field.getValue());
        field = new ShortField(30);
        Assert.assertEquals((long)30L, (long)field.getValue());
    }

    @Test
    public void objectField_structure() {
        ObjectField field = new ObjectField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", BasicRef.class);
    }

    @Test
    public void objectField_Usage() {
        ObjectField field = new ObjectField();
        Assert.assertNull((Object)field.getValue());
        field.setValue("foo");
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
        field = new ObjectField("bar");
        Assert.assertEquals((Object)"bar", (Object)field.getValue());
    }

    @Test
    public void typedField_structure() {
        TypedField field = new TypedField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", BasicRef.class);
    }

    @Test
    public void typedField_Usage() {
        TypedField field = new TypedField();
        Assert.assertNull((Object)field.getValue());
        field.setValue("foo");
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
        field = new TypedField("bar");
        Assert.assertEquals((Object)"bar", (Object)field.getValue());
    }

    @Test
    public void arrayField_structure() {
        ArrayField field = new ArrayField();
        Assert.assertFalse((boolean)(field instanceof AlphaTransactionalObject));
        AlphaReflectionUtils.assertHasField(field.getClass(), "value", BasicRef.class);
    }

    @Test
    public void arrayField_Usage() {
        ArrayField field = new ArrayField();
        Assert.assertNull((Object)field.getValue());
        field.setValue(new String[]{"foo"});
        Assert.assertTrue((boolean)((Object)Arrays.asList(field.getValue())).equals(Arrays.asList("foo")));
        field = new ArrayField(new String[]{"bar"});
        Assert.assertTrue((boolean)((Object)Arrays.asList(field.getValue())).equals(Arrays.asList("bar")));
    }

    @TransactionalObject
    private static class ArrayField {
        @FieldGranularity
        private String[] value;

        public ArrayField() {
        }

        public ArrayField(String[] value) {
            this.value = value;
        }

        public String[] getValue() {
            return this.value;
        }

        public void setValue(String[] value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class TypedField {
        @FieldGranularity
        private String value;

        public TypedField() {
        }

        public TypedField(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class ObjectField {
        @FieldGranularity
        private Object value;

        public ObjectField() {
        }

        public ObjectField(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class ShortField {
        @FieldGranularity
        private short value;

        public ShortField() {
        }

        public ShortField(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public void setValue(short value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class DoubleField {
        @FieldGranularity
        private double value;

        public DoubleField() {
        }

        public DoubleField(int value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class LongField {
        @FieldGranularity
        private long value;

        public LongField() {
        }

        public LongField(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class CharField {
        @FieldGranularity
        private char value;

        public CharField() {
        }

        public CharField(char value) {
            this.value = value;
        }

        public char getValue() {
            return this.value;
        }

        public void setValue(char value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class ByteField {
        @FieldGranularity
        private byte value;

        public ByteField() {
        }

        public ByteField(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public void setValue(byte value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class BooleanField {
        @FieldGranularity
        private boolean value;

        public BooleanField() {
        }

        public BooleanField(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class FloatField {
        @FieldGranularity
        private float value;

        public FloatField() {
        }

        public FloatField(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }
    }

    @TransactionalObject
    private static class IntField {
        @FieldGranularity
        private int value;

        public IntField() {
        }

        private IntField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class PackageFriendlyField {
        @FieldGranularity
        int value;

        public PackageFriendlyField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class PublicField {
        @FieldGranularity
        protected int value;

        public PublicField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class ProtectedField {
        @FieldGranularity
        protected int value;

        public ProtectedField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public static class PrivateField {
        @FieldGranularity
        private int value;

        public PrivateField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

