/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.gettersetter;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;

public class SetterInlinePerformanceTest {
    private static final int incCount = 200000000;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void inlinedGetterSetter() {
        long startNs = System.nanoTime();
        Foo foo = new Foo();
        foo.loopWithInlinedGetterSetter();
        long durationNs = System.nanoTime() - startNs;
        double incPerSecond = 2.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s inc/second\n", incPerSecond);
    }

    @Test
    public void fastLoop() {
        long startNs = System.nanoTime();
        Foo foo = new Foo();
        foo.loop();
        long durationNs = System.nanoTime() - startNs;
        double incPerSecond = 2.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s inc/second\n", incPerSecond);
    }

    @Test
    public void nonOptimizedLoop() {
        long startNs = System.nanoTime();
        Foo foo = new Foo();
        foo.nonOptimizedLoop();
        long durationNs = System.nanoTime() - startNs;
        double incPerSecond = 2.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s inc/second\n", incPerSecond);
    }

    @TransactionalObject
    public class Foo {
        int value;

        final int get() {
            return this.value;
        }

        final void set(int value) {
            this.value = value;
        }

        final int get(int destroyOptimization) {
            return this.value;
        }

        final void set(int value, int destroyOptimization) {
            this.value = value;
        }

        void loopWithInlinedGetterSetter() {
            for (int k = 0; k < 200000000; ++k) {
                this.set(this.get() + 1);
                if (k % 200000000 != 0) continue;
                System.out.println(k);
            }
        }

        void loop() {
            for (int k = 0; k < 200000000; ++k) {
                ++this.value;
                if (k % 200000000 != 0) continue;
                System.out.println(k);
            }
        }

        void nonOptimizedLoop() {
            for (int k = 0; k < 200000000; ++k) {
                this.set(this.get(0) + 1, 0);
                if (k % 200000000 != 0) continue;
                System.out.println(k);
            }
        }
    }
}

