/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest.languageconstructs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.manualinstrumentation.IntRef;

public class SwitchCaseTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenUsedInExpression() {
        Assert.assertEquals((long)10L, (long)this.usedInExpression(new IntRef(1)));
        Assert.assertEquals((long)20L, (long)this.usedInExpression(new IntRef(2)));
        Assert.assertEquals((long)30L, (long)this.usedInExpression(new IntRef(3)));
    }

    @TransactionalMethod
    public int usedInExpression(IntRef ref) {
        switch (ref.get()) {
            case 1: {
                return 10;
            }
            case 2: {
                return 20;
            }
        }
        return 30;
    }

    @Test
    public void whenUsedInStatement() {
        IntRef ref = new IntRef();
        this.usedInStatement(0, ref);
        Assert.assertEquals((long)10L, (long)ref.get());
        ref.set(0);
        this.usedInStatement(1, ref);
        Assert.assertEquals((long)20L, (long)ref.get());
        ref.set(0);
        this.usedInStatement(3, ref);
        Assert.assertEquals((long)30L, (long)ref.get());
    }

    @TransactionalMethod
    public void usedInStatement(int value, IntRef ref) {
        switch (value) {
            case 0: {
                ref.set(10);
                break;
            }
            case 1: {
                ref.set(20);
                break;
            }
            default: {
                ref.set(30);
            }
        }
    }
}

