/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest.languageconstructs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.alpha.instrumentation.integrationtest.languageconstructs.ExpectedRuntimeException;
import org.multiverse.stms.alpha.manualinstrumentation.IntRef;

public class TryCatchTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenUsedInCatchClause() {
        IntRef ref = new IntRef();
        this.methodWhereExceptionCaught(ref);
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @TransactionalMethod(readonly=false)
    public void methodWhereExceptionCaught(IntRef ref) {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            ref.set(1);
            return;
        }
    }

    @Test
    public void whenUsedInFinallyClauseWithoutException() {
        IntRef ref = new IntRef();
        this.methodWithFinallyClause(false, ref);
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test
    @Ignore
    public void whenUsedInFinallyClauseWithException() {
        IntRef ref = new IntRef();
        try {
            this.methodWithFinallyClause(true, ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionalMethod(readonly=false)
    public void methodWithFinallyClause(boolean error, IntRef ref) {
        try {
            if (error) {
                throw new ExpectedRuntimeException();
            }
        }
        finally {
            ref.set(1);
            ThreadLocalTransaction.getThreadLocalTransaction().commit();
        }
    }
}

