/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest.languageconstructs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class WhileLoopTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenUsedInExpression() {
        IntRef ref = new IntRef(0);
        int result = this.expressionInWhileLoop(ref);
        Assert.assertEquals((long)10L, (long)result);
    }

    @TransactionalMethod(readonly=false)
    public int expressionInWhileLoop(IntRef ref) {
        int result;
        for (result = 0; ref.get() < 10 && result < 10; ++result) {
        }
        return result;
    }

    @Test
    public void whenUsedInLoop() {
        IntRef ref = new IntRef();
        this.referenceInWhileLoop(ref);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @TransactionalMethod(readonly=false)
    public void referenceInWhileLoop(IntRef ref) {
        for (int x = 0; x < 10; ++x) {
            ref.inc();
        }
    }
}

