/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.javaagent.JavaAgentProblemMonitor;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalMethod_InterruptibleTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    @Test
    public void whenNoException_thenError() {
        System.out.println("---------------- following error is expected ----------------------");
        MethodWithoutException o = new MethodWithoutException();
        Assert.assertTrue((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @Test
    public void whenNoMatchingException() {
        System.out.println("---------------- following error is expected ----------------------");
        MethodWithIncorrectException o = new MethodWithIncorrectException();
        Assert.assertTrue((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @Test
    public void whenInterruptedExceptionPresent() {
        MethodWithInterruptedException o = new MethodWithInterruptedException();
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @Test
    public void whenExceptionPresent() {
        MethodWithException o = new MethodWithException();
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @Test
    public void whenThrowablePresent() {
        MethodWithThrowable o = new MethodWithThrowable();
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @Test
    public void whenMultipleExceptionsAndAtLeastOneMatching() {
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
        MethodWithMultipleExceptions o = new MethodWithMultipleExceptions();
        Assert.assertFalse((boolean)JavaAgentProblemMonitor.INSTANCE.isProblemFound());
    }

    @TransactionalObject
    public static class MethodWithMultipleExceptions {
        private int x;

        @TransactionalMethod(interruptible=true)
        public void method() throws NullPointerException, InterruptedException, IllegalArgumentException {
            this.x = 10;
        }
    }

    @TransactionalObject
    public static class MethodWithThrowable {
        private int x;

        @TransactionalMethod(interruptible=true)
        public void method() throws Exception {
            this.x = 10;
        }
    }

    @TransactionalObject
    public static class MethodWithException {
        private int x;

        @TransactionalMethod(interruptible=true)
        public void method() throws Exception {
            this.x = 10;
        }
    }

    @TransactionalObject
    public static class MethodWithInterruptedException {
        private int x;

        @TransactionalMethod(interruptible=true)
        public void method() throws InterruptedException {
            this.x = 10;
        }
    }

    @TransactionalObject
    public static class MethodWithIncorrectException {
        private int x;

        @TransactionalMethod(interruptible=true)
        public void method() throws RuntimeException {
            this.x = 10;
        }
    }

    @TransactionalObject
    public static class MethodWithoutException {
        private int x;

        @TransactionalMethod(interruptible=true)
        public void method() {
            this.x = 10;
        }
    }
}

