/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.stms.alpha.AlphaStm;

public class IndependentScalabilityPerformanceTest {
    private volatile boolean stop;

    @Test
    public void testWithSharedStm() {
        this.test(true);
    }

    @Test
    public void testNoSharedStm() {
        this.test(false);
    }

    private void test(boolean share) {
        int k;
        int processorCount = Math.max(4, TestUtils.processorCount() / 2);
        TestResult[] results = new TestResult[processorCount];
        for (k = 0; k < processorCount; ++k) {
            results[k] = this.test(share, k + 1);
        }
        for (k = 0; k < results.length; ++k) {
            TestResult result = results[k];
            System.out.printf("%s processors took %s seconds, %s transactions/second, speedupfactor %s\n", result.processorCount, result.durationMs, TestUtils.format((double)result.performance()), TestUtils.format((double)(result.performance() / results[0].performance())));
        }
    }

    public TestResult test(boolean share, int threadCount) {
        this.stop = false;
        System.out.println("--------------------------------------------------------");
        System.out.printf("starting with %s threads\n", threadCount);
        System.out.println("--------------------------------------------------------");
        CheapLatch startLatch = new CheapLatch();
        TestThread[] threads = this.createThreads(share, (Latch)startLatch, threadCount);
        TestUtils.startAll((TestThread[])threads);
        long startMs = System.currentTimeMillis();
        startLatch.open();
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)10000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        return new TestResult(System.currentTimeMillis() - startMs, this.sum((ModifyThread[])threads), threadCount);
    }

    public ModifyThread[] createThreads(boolean share, Latch startLatch, int threadCount) {
        ModifyThread[] threads = new ModifyThread[threadCount];
        AlphaStm stm = null;
        for (int k = 0; k < threads.length; ++k) {
            if (share) {
                if (stm == null) {
                    stm = AlphaStm.createFast();
                }
            } else {
                stm = AlphaStm.createFast();
            }
            threads[k] = new ModifyThread(k, stm.getProgrammaticRefFactoryBuilder().build().atomicCreateLongRef(0L), startLatch);
        }
        return threads;
    }

    long sum(ModifyThread[] threads) {
        long result = 0L;
        for (ModifyThread t : threads) {
            result += t.incCount;
        }
        return result;
    }

    class ModifyThread
    extends TestThread {
        private final ProgrammaticLongRef ref;
        private final Latch startLatch;
        private long incCount;

        public ModifyThread(int id, ProgrammaticLongRef ref, Latch startLatch) {
            super("Thread-" + id);
            this.startLatch = startLatch;
            this.ref = ref;
        }

        public void doRun() {
            this.startLatch.awaitUninterruptible();
            while (!IndependentScalabilityPerformanceTest.this.stop) {
                this.ref.inc(1L);
                ++this.incCount;
                if (this.incCount % 10000000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.incCount);
            }
        }
    }

    class TestResult {
        final long transactionCount;
        final long durationMs;
        final int processorCount;

        TestResult(long durationMs, long transactionCount, int processorCount) {
            this.durationMs = durationMs;
            this.transactionCount = transactionCount;
            this.processorCount = processorCount;
        }

        double performance() {
            return this.transactionCount * TimeUnit.SECONDS.toMillis(1L) / this.durationMs;
        }
    }
}

