/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.transactional.refs.IntRef;

public class NonBlockingAccessTest {
    private AlphaStm stm;
    private TransactionFactory<AlphaTransaction> updateTxFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void writerDoesNotBlockReader() {
        IntRef ref = new IntRef(0);
        Transaction t1 = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t1);
        ref.inc();
        Transaction t2 = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t2);
        int value = ref.get();
        t2.commit();
        Assert.assertEquals((long)0L, (long)value);
    }

    @Test
    public void writerDoesNotBlockWriter() {
        IntRef ref = new IntRef(0);
        Transaction t1 = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t1);
        ref.inc();
        Transaction t2 = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t2);
        ref.inc();
        t2.commit();
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test
    public void readerDoesNotBlockWriter() {
        IntRef ref = new IntRef(0);
        Transaction t1 = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t1);
        ref.get();
        Transaction t2 = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t2);
        ref.inc();
        t2.commit();
        Assert.assertEquals((long)1L, (long)ref.get());
    }
}

