/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.IntRef;
import org.multiverse.stms.alpha.manualinstrumentation.IntRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class IntRefTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    public AlphaTransaction startTransaction() {
        AlphaTransaction t = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void isDirty_freshObject() {
        AlphaTransaction t = this.startTransaction();
        IntRef value = new IntRef(0);
        IntRefTranlocal tranlocal = (IntRefTranlocal)t.openForWrite((AlphaTransactionalObject)value);
        Assert.assertTrue((boolean)tranlocal.isDirty());
    }

    @Test
    public void isDirty_readonlyObject() {
        IntRef value = new IntRef(0);
        AlphaTransaction t = this.startTransaction();
        IntRefTranlocal tranlocal = (IntRefTranlocal)t.openForWrite((AlphaTransactionalObject)value);
        Assert.assertFalse((boolean)tranlocal.isDirty());
    }

    @Test
    public void isDirty_dirtyObject() {
        IntRef value = new IntRef(0);
        AlphaTransaction t = this.startTransaction();
        value.inc();
        IntRefTranlocal tranlocal = (IntRefTranlocal)t.openForWrite((AlphaTransactionalObject)value);
        Assert.assertTrue((boolean)tranlocal.isDirty());
    }

    @Test
    public void hasConflict_withConflict() {
        IntRef value = new IntRef(0);
        AlphaTransaction t1 = this.startTransaction();
        value.inc();
        AlphaTransaction t2 = this.startTransaction();
        value.inc();
        t2.commit();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t1);
        IntRefTranlocal tranlocal = (IntRefTranlocal)t1.openForWrite((AlphaTransactionalObject)value);
        Assert.assertTrue((boolean)tranlocal.hasReadConflict((Transaction)t1));
    }

    @Test
    public void atomicCreation() {
        long startVersion = this.stm.getVersion();
        IntRef intValue2 = new IntRef(10);
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)10L, (long)intValue2.get());
    }

    @Test
    public void atomicGet() {
        IntRef intValue2 = new IntRef(10);
        long startVersion = this.stm.getVersion();
        int result = intValue2.get();
        Assert.assertEquals((long)10L, (long)result);
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
    }

    @Test
    public void atomicSet() {
        IntRef intValue2 = new IntRef(10);
        long startVersion = this.stm.getVersion();
        intValue2.set(100);
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)100L, (long)intValue2.get());
    }

    @Test
    public void atomicInc() {
        IntRef intValue2 = new IntRef(10);
        long startVersion = this.stm.getVersion();
        intValue2.inc();
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)intValue2.get());
    }

    @Test
    public void existingTransaction() {
        AlphaTransaction t1 = this.startTransaction();
        IntRef intValue2 = new IntRef(10);
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        Assert.assertEquals((long)10L, (long)intValue2.get());
        intValue2.inc();
        Assert.assertEquals((long)11L, (long)intValue2.get());
        t2.commit();
    }

    @Test
    public void existingTransaction2() {
        AlphaTransaction t1 = this.startTransaction();
        IntRef intValue2 = new IntRef(10);
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        Assert.assertEquals((long)10L, (long)intValue2.get());
    }

    @Test
    public void testSingleTransaction() {
        AlphaTransaction t1 = this.startTransaction();
        IntRef intValue2 = new IntRef(10);
        intValue2.inc();
        Assert.assertEquals((long)11L, (long)intValue2.get());
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        Assert.assertEquals((long)11L, (long)intValue2.get());
    }

    @Test
    public void testRollback() {
        AlphaTransaction t1 = this.startTransaction();
        IntRef intValue2 = new IntRef(10);
        t1.commit();
        AlphaTransaction t2 = this.startTransaction();
        intValue2.inc();
        t2.abort();
        AlphaTransaction t3 = this.startTransaction();
        Assert.assertEquals((long)10L, (long)intValue2.get());
    }
}

