/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.manualinstrumentation.Stack;
import org.multiverse.templates.TransactionTemplate;

public class Queue<E> {
    private final Stack<E> pushedStack;
    private final Stack<E> readyToPopStack;
    private final int maxCapacity;
    private static final TransactionFactory sizeTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();
    private static final TransactionFactory isEmptyTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();

    public Queue(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.pushedStack = new Stack();
        this.readyToPopStack = new Stack();
        this.maxCapacity = maxCapacity;
    }

    public Queue() {
        this(Integer.MAX_VALUE);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void push(final E item) {
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                if (Queue.this.size() > Queue.this.maxCapacity) {
                    throw new IllegalStateException();
                }
                Queue.this.pushedStack.push(item);
                return null;
            }
        }.execute();
    }

    public E take() {
        return (E)new TransactionTemplate<E>(){

            public E execute(Transaction t) throws Exception {
                if (Queue.this.readyToPopStack.isEmpty()) {
                    while (!Queue.this.pushedStack.isEmpty()) {
                        Queue.this.readyToPopStack.push(Queue.this.pushedStack.pop());
                    }
                }
                return Queue.this.readyToPopStack.pop();
            }
        }.execute();
    }

    public int size() {
        return (Integer)new TransactionTemplate<Integer>(sizeTxFactory){

            public Integer execute(Transaction t) throws Exception {
                return Queue.this.pushedStack.size() + Queue.this.readyToPopStack.size();
            }
        }.execute();
    }

    public boolean isEmpty() {
        return (Boolean)new TransactionTemplate<Boolean>(isEmptyTxFactory){

            public Boolean execute(Transaction t) throws Exception {
                return Queue.this.pushedStack.isEmpty() && Queue.this.readyToPopStack.isEmpty();
            }
        }.execute();
    }
}

